#ifndef _MFSK_H
#define _MFSK_H

#include "cmplx.h"
#include "trx.h"
#include "viterbi.h"
#include "interleave.h"

#define	SampleRate	8000

//#define	SymbolLen	512
//#define	BaseTone	64
//#define	NumTones	16
//#define	SymbolRate	((float)SampleRate/SymbolLen)
//#define	ToneSpacing	SymbolRate

//#define	PipeLen		(2*SymbolLen)

struct rxpipe {
	complex vector[32];	/* numtones <= 32 */
	int symbol;
};

struct mfsk {
	/*
	 * Common stuff
	 */
	double phaseacc;

	int symlen;
	int symbits;
	int numtones;
	int basetone;
	double tonespacing;

	/*
	 * RX related stuff
	 */
	struct filter *hilbert;
	struct sfft *sfft;
	struct viterbi_old *viterbi;

	struct viterbi *dec1;
	struct viterbi *dec2;
	struct interleave *rxinlv;

	struct rxpipe *pipe;
	unsigned int pipeptr;

	unsigned int datashreg;

	complex currvector;
	complex prev1vector;
	complex prev2vector;

	int currsymbol;
	int prev1symbol;
	int prev2symbol;

	float metric1;
	float metric2;

	unsigned int symbolphase;
	unsigned int symboltime;
	float syncaverage;
	int synccounter;

	unsigned char symbolpair[2];
	int symcounter;

	/*
	 * TX related stuff
	 */
	struct fft *fft;

	struct encoder *enc;
	struct interleave *txinlv;

	unsigned int bitshreg;
	int bitstate;
	int txstate;
};

#define	STATE_PREAMBLE		0
#define	STATE_START		1
#define	STATE_DATA		2
#define	STATE_END		3
#define	STATE_FLUSH		4
#define	STATE_FINISH		5
#define	STATE_TUNE		6

/* in mfsk.c */
extern void mfsk_init(struct trx *trx);

/* in mfskrx.c */
extern int mfsk_rxprocess(struct trx *trx, float *buf, int len);

/* in mfsktx.c */
extern int mfsk_txprocess(struct trx *trx);

#endif
