/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2000 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"

#include "procedural_db.h"

#include <string.h>

#include "gimpcontext.h"
#include "gradient_header.h"
#include "gradient_select.h"

static ProcRecord gradients_popup_proc;
static ProcRecord gradients_close_popup_proc;
static ProcRecord gradients_set_popup_proc;
static ProcRecord gradients_get_gradient_data_proc;

void
register_gradient_select_procs (void)
{
  procedural_db_register (&gradients_popup_proc);
  procedural_db_register (&gradients_close_popup_proc);
  procedural_db_register (&gradients_set_popup_proc);
  procedural_db_register (&gradients_get_gradient_data_proc);
}

static GradientSelect *
gradients_get_gradientselect (gchar *name)
{
  GSList *list;
  GradientSelect *gsp;

  for (list = gradient_active_dialogs; list; list = g_slist_next (list))
    {
      gsp = (GradientSelect *) list->data;
      
      if (gsp->callback_name && !strcmp (name, gsp->callback_name))
	return gsp;
    }

  return NULL;
}

static Argument *
gradients_popup_invoker (Argument *args)
{
  gboolean success = TRUE;
  gchar *name;
  gchar *title;
  gchar *initial_gradient;
  gint32 sample_size;
  ProcRecord *prec;
  GradientSelect *newdialog;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL)
    success = FALSE;

  title = (gchar *) args[1].value.pdb_pointer;
  if (title == NULL)
    success = FALSE;

  initial_gradient = (gchar *) args[2].value.pdb_pointer;

  sample_size = args[3].value.pdb_int;
  if (sample_size <= 0 || sample_size > 10000)
    sample_size = GRADIENT_SAMPLE_SIZE;

  if (success)
    {
      if ((prec = procedural_db_lookup (name)))
	{
	  if (initial_gradient && strlen (initial_gradient))
	    newdialog = gradient_select_new (title, initial_gradient);
	  else
	    newdialog = gradient_select_new (title, NULL);
    
	  newdialog->callback_name = g_strdup (name);
	  newdialog->sample_size   = sample_size;
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&gradients_popup_proc, success);
}

static ProcArg gradients_popup_inargs[] =
{
  {
    PDB_STRING,
    "gradients_callback",
    "The callback PDB proc to call when gradient selection is made"
  },
  {
    PDB_STRING,
    "popup_title",
    "Title to give the gradient popup window"
  },
  {
    PDB_STRING,
    "initial_gradient",
    "The name of the pattern to set as the first selected"
  },
  {
    PDB_INT32,
    "sample_size",
    "Size of the sample to return when the gradient is changed (0 < sample_size <= 10000)"
  }
};

static ProcRecord gradients_popup_proc =
{
  "gimp_gradients_popup",
  "Invokes the Gimp gradients selection.",
  "This procedure popups the gradients selection dialog.",
  "Andy Thomas",
  "Andy Thomas",
  "1998",
  PDB_INTERNAL,
  4,
  gradients_popup_inargs,
  0,
  NULL,
  { { gradients_popup_invoker } }
};

static Argument *
gradients_close_popup_invoker (Argument *args)
{
  gboolean success = TRUE;
  gchar *name;
  ProcRecord *prec;
  GradientSelect *gsp;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL)
    success = FALSE;

  if (success)
    {
      if ((prec = procedural_db_lookup (name)) &&
	  (gsp = gradients_get_gradientselect (name)))
	{
	  if (GTK_WIDGET_VISIBLE (gsp->shell))
	    gtk_widget_hide (gsp->shell);
    
	  /* Free memory if poping down dialog which is not the main one */
	  if (gsp != gradient_select_dialog)
	    {
	      /* Send data back */
	      gtk_widget_destroy (gsp->shell);
	      gradient_select_free (gsp);
	    }
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&gradients_close_popup_proc, success);
}

static ProcArg gradients_close_popup_inargs[] =
{
  {
    PDB_STRING,
    "gradients_callback",
    "The name of the callback registered for this popup"
  }
};

static ProcRecord gradients_close_popup_proc =
{
  "gimp_gradients_close_popup",
  "Popdown the Gimp gradient selection.",
  "This procedure closes an opened gradient selection dialog.",
  "Andy Thomas",
  "Andy Thomas",
  "1998",
  PDB_INTERNAL,
  1,
  gradients_close_popup_inargs,
  0,
  NULL,
  { { gradients_close_popup_invoker } }
};

static Argument *
gradients_set_popup_invoker (Argument *args)
{
  gboolean success = TRUE;
  gchar *pdbname;
  gchar *gradient_name;
  ProcRecord *prec;
  GradientSelect *gsp;

  pdbname = (gchar *) args[0].value.pdb_pointer;
  if (pdbname == NULL)
    success = FALSE;

  gradient_name = (gchar *) args[1].value.pdb_pointer;
  if (gradient_name == NULL)
    success = FALSE;

  if (success)
    {
      if ((prec = procedural_db_lookup (pdbname)) &&
	  (gsp = gradients_get_gradientselect (pdbname)))
	{
	  GSList *list;
	  gradient_t *active = NULL;
    
	  for (list = gradients_list; list; list = g_slist_next (list))
	     {
	      active = (gradient_t *) list->data;
    
	      if (!strcmp (gradient_name, active->name))
		break; /* We found the one we want */
	    }
    
	  if (active)
	    {
	      gimp_context_set_gradient (gsp->context, active);
	    }
	  else
	    success = FALSE;
	}
      else
	success = FALSE;
    }

  return procedural_db_return_args (&gradients_set_popup_proc, success);
}

static ProcArg gradients_set_popup_inargs[] =
{
  {
    PDB_STRING,
    "gradients_callback",
    "The name of the callback registered for this popup"
  },
  {
    PDB_STRING,
    "gradient_name",
    "The name of the gradient to set as selected"
  }
};

static ProcRecord gradients_set_popup_proc =
{
  "gimp_gradients_set_popup",
  "Sets the current gradient selection in a popup.",
  "Sets the current gradient selection in a popup.",
  "Andy Thomas",
  "Andy Thomas",
  "1998",
  PDB_INTERNAL,
  2,
  gradients_set_popup_inargs,
  0,
  NULL,
  { { gradients_set_popup_invoker } }
};

static Argument *
gradients_get_gradient_data_invoker (Argument *args)
{
  gboolean success = TRUE;
  Argument *return_args;
  gchar *name;
  gint32 sample_size;
  gdouble *values = NULL;
  gradient_t *gradient = NULL;

  name = (gchar *) args[0].value.pdb_pointer;
  if (name == NULL)
    success = FALSE;

  sample_size = args[1].value.pdb_int;
  if (sample_size <= 0 || sample_size > 10000)
    sample_size = GRADIENT_SAMPLE_SIZE;

  if (success)
    {
      if (strlen (name))
	{
	  GSList *list;
    
	  success = FALSE;
    
	  for (list = gradients_list; list; list = g_slist_next (list))
	    {
	      gradient = (gradient_t *) list->data;
    
	      if (!strcmp (gradient->name, name))
		{
		  success = TRUE;
		  break;      /* We found it! */
		}
	    }
	}
      else
	success = (gradient = gimp_context_get_gradient (NULL)) != NULL;
    
      if (success)
	{
	  gdouble *pv;
	  gdouble pos, delta;
	  gdouble r, g, b, a;
	  int i = sample_size;
    
	  pos = 0.0;
	  delta = 1.0 / (i - 1);
    
	  pv = values = g_new (gdouble, i * 4);
    
	  while (i--)
	    {
	      gradient_get_color_at (gradient, pos, &r, &g, &b, &a);
    
	      *pv++ = r;
	      *pv++ = g;
	      *pv++ = b;
	      *pv++ = a;
    
	      pos += delta;
	    }
	}
    }

  return_args = procedural_db_return_args (&gradients_get_gradient_data_proc, success);

  if (success)
    {
      return_args[1].value.pdb_pointer = g_strdup (gradient->name);
      return_args[2].value.pdb_int = sample_size * 4;
      return_args[3].value.pdb_pointer = values;
    }

  return return_args;
}

static ProcArg gradients_get_gradient_data_inargs[] =
{
  {
    PDB_STRING,
    "name",
    "The gradient name (\"\" means current active gradient)"
  },
  {
    PDB_INT32,
    "sample_size",
    "Size of the sample to return when the gradient is changed (0 < sample_size <= 10000)"
  }
};

static ProcArg gradients_get_gradient_data_outargs[] =
{
  {
    PDB_STRING,
    "name",
    "The gradient name"
  },
  {
    PDB_INT32,
    "width",
    "The gradient sample width (r,g,b,a)"
  },
  {
    PDB_FLOATARRAY,
    "grad_data",
    "The gradient sample data"
  }
};

static ProcRecord gradients_get_gradient_data_proc =
{
  "gimp_gradients_get_gradient_data",
  "Retrieve information about the specified gradient (including data).",
  "This procedure retrieves information about the gradient. This includes the gradient name, and the sample data for the gradient.",
  "Andy Thomas",
  "Andy Thomas",
  "1998",
  PDB_INTERNAL,
  2,
  gradients_get_gradient_data_inargs,
  3,
  gradients_get_gradient_data_outargs,
  { { gradients_get_gradient_data_invoker } }
};
