/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.CardGeneration;
import sun.jvm.hotspot.memory.ContiguousSpace;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public abstract class OneContigSpaceCardGeneration
extends CardGeneration {
    private static AddressField theSpaceField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("OneContigSpaceCardGeneration");
        theSpaceField = type.getAddressField("_the_space");
    }

    public OneContigSpaceCardGeneration(Address addr) {
        super(addr);
    }

    public ContiguousSpace theSpace() {
        return (ContiguousSpace)VMObjectFactory.newObject(ContiguousSpace.class, theSpaceField.getValue(this.addr));
    }

    public boolean isIn(Address p) {
        return this.theSpace().contains(p);
    }

    public long capacity() {
        return this.theSpace().capacity();
    }

    public long used() {
        return this.theSpace().used();
    }

    public long free() {
        return this.theSpace().free();
    }

    public long contiguousAvailable() {
        return this.theSpace().free() + this.virtualSpace().uncommittedSize();
    }

    public void spaceIterate(SpaceClosure blk, boolean usedOnly) {
        blk.doSpace(this.theSpace());
    }

    public void printOn(PrintStream tty) {
        tty.print("  old ");
        this.theSpace().printOn(tty);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                OneContigSpaceCardGeneration.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

