/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.Font;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DemoFonts {
    private static String[] names = new String[]{"A.ttf"};
    private static Map<String, Font> cache = new ConcurrentHashMap<String, Font>(names.length);

    public static Font getFont(String string) {
        Font font = null;
        if (cache != null && (font = cache.get(string)) != null) {
            return font;
        }
        String string2 = "/fonts/" + string;
        try {
            InputStream inputStream = DemoFonts.class.getResourceAsStream(string2);
            font = Font.createFont(0, inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(string2 + " not loaded.  Using serif font.");
            font = new Font("serif", 0, 24);
        }
        return font;
    }

    static {
        for (String string : names) {
            cache.put(string, DemoFonts.getFont(string));
        }
    }
}

