/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.XArrayDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XOpenTypeViewer;
import sun.tools.jconsole.inspector.XPlottingViewer;

public class XDataViewer {
    public static final int OPEN = 1;
    public static final int ARRAY = 2;
    public static final int NUMERIC = 3;
    public static final int NOT_SUPPORTED = 4;
    private MBeansTab tab;

    public XDataViewer(MBeansTab mBeansTab) {
        this.tab = mBeansTab;
    }

    public static void registerForMouseEvent(Component component, MouseListener mouseListener) {
        Container container;
        if (component instanceof JScrollPane) {
            container = (JScrollPane)component;
            component = ((JScrollPane)container).getViewport().getView();
        }
        if (component instanceof Container) {
            container = (Container)component;
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                XDataViewer.registerForMouseEvent(componentArray[i], mouseListener);
            }
        }
        if (component != null && !(component instanceof XOpenTypeViewer.XOpenTypeData) && !(component instanceof JButton)) {
            component.addMouseListener(mouseListener);
        }
    }

    public static void dispose(MBeansTab mBeansTab) {
        XPlottingViewer.dispose(mBeansTab);
    }

    public static boolean isViewableValue(Object object) {
        boolean bl = false;
        bl = XArrayDataViewer.isViewableValue(object);
        if (bl) {
            return bl;
        }
        bl = XOpenTypeViewer.isViewableValue(object);
        if (bl) {
            return bl;
        }
        bl = XPlottingViewer.isViewableValue(object);
        if (bl) {
            return bl;
        }
        return bl;
    }

    public static int getViewerType(Object object) {
        if (XArrayDataViewer.isViewableValue(object)) {
            return 2;
        }
        if (XOpenTypeViewer.isViewableValue(object)) {
            return 1;
        }
        if (XPlottingViewer.isViewableValue(object)) {
            return 3;
        }
        return 4;
    }

    public static String getActionLabel(int n) {
        if (n == 2 || n == 1) {
            return Resources.getText("visualize", new Object[0]);
        }
        if (n == 3) {
            return Resources.getText("plot", new Object[0]);
        }
        return Resources.getText("expand", new Object[0]);
    }

    public Component createOperationViewer(Object object, XMBean xMBean) {
        if (object instanceof Number) {
            return null;
        }
        return this.createAttributeViewer(object, xMBean, null, null);
    }

    public static Component createNotificationViewer(Object object) {
        Component component = null;
        if (object instanceof Number) {
            return null;
        }
        component = XArrayDataViewer.loadArray(object);
        if (component != null) {
            return component;
        }
        component = XOpenTypeViewer.loadOpenType(object);
        if (component != null) {
            return component;
        }
        return component;
    }

    public Component createAttributeViewer(Object object, XMBean xMBean, String string, JTable jTable) {
        Component component = null;
        component = XArrayDataViewer.loadArray(object);
        if (component != null) {
            return component;
        }
        component = XOpenTypeViewer.loadOpenType(object);
        if (component != null) {
            return component;
        }
        component = XPlottingViewer.loadPlotting(xMBean, string, object, jTable, this.tab);
        if (component != null) {
            return component;
        }
        return component;
    }
}

