/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class MetalToolTipUI
extends BasicToolTipUI {
    static MetalToolTipUI sharedInstance = new MetalToolTipUI();
    private Font smallFont;
    private JToolTip tip;
    public static final int padSpaceBetweenStrings = 12;
    private String acceleratorDelimiter;

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tip = (JToolTip)jComponent;
        Font font = jComponent.getFont();
        this.smallFont = new Font(font.getName(), font.getStyle(), font.getSize() - 2);
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "-";
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.tip = null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JToolTip jToolTip = (JToolTip)jComponent;
        super.paint(graphics, jComponent);
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(jComponent, graphics, font);
        String string = this.getAcceleratorString(jToolTip);
        String string2 = jToolTip.getTipText();
        if (string2 == null) {
            string2 = "";
        }
        if (!string.equals("")) {
            graphics.setFont(this.smallFont);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            SwingUtilities2.drawString((JComponent)jToolTip, graphics, string, SwingUtilities2.stringWidth(jToolTip, fontMetrics, string2) + 12, 2 + fontMetrics.getAscent());
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        String string = this.getAcceleratorString((JToolTip)jComponent);
        if (!string.equals("")) {
            FontMetrics fontMetrics = jComponent.getFontMetrics(this.smallFont);
            dimension.width += SwingUtilities2.stringWidth(jComponent, fontMetrics, string) + 12;
        }
        return dimension;
    }

    protected boolean isAcceleratorHidden() {
        Boolean bl2 = (Boolean)UIManager.get("ToolTip.hideAccelerator");
        return bl2 != null && bl2 != false;
    }

    private String getAcceleratorString(JToolTip jToolTip) {
        this.tip = jToolTip;
        String string = this.getAcceleratorString();
        this.tip = null;
        return string;
    }

    public String getAcceleratorString() {
        int n2;
        KeyStroke[] keyStrokeArray;
        int n3;
        Object object;
        if (this.tip == null || this.isAcceleratorHidden()) {
            return "";
        }
        JComponent jComponent = this.tip.getComponent();
        if (jComponent == null) {
            return "";
        }
        if (jComponent instanceof JTabbedPane) {
            object = ((JTabbedPane)jComponent).getUI();
            if (object instanceof MetalTabbedPaneUI) {
                n3 = ((MetalTabbedPaneUI)object).getRolloverTabIndex();
                if (n3 == -1) {
                    keyStrokeArray = new KeyStroke[]{};
                } else {
                    n2 = ((JTabbedPane)jComponent).getMnemonicAt(n3);
                    if (n2 == -1) {
                        keyStrokeArray = new KeyStroke[]{};
                    } else {
                        KeyStroke keyStroke = KeyStroke.getKeyStroke(n2, 8);
                        keyStrokeArray = new KeyStroke[]{keyStroke};
                    }
                }
            } else {
                keyStrokeArray = jComponent.getRegisteredKeyStrokes();
            }
        } else {
            keyStrokeArray = jComponent.getRegisteredKeyStrokes();
        }
        object = "";
        for (n3 = 0; n3 < keyStrokeArray.length; ++n3) {
            n2 = keyStrokeArray[n3].getModifiers();
            int n4 = jComponent.getConditionForKeyStroke(keyStrokeArray[n3]);
            if (n4 != 2) continue;
            object = KeyEvent.getKeyModifiersText(n2) + this.acceleratorDelimiter + KeyEvent.getKeyText(keyStrokeArray[n3].getKeyCode());
            break;
        }
        if (((String)object).equals("") && jComponent instanceof JMenuItem && (n3 = ((JMenuItem)jComponent).getMnemonic()) != 0) {
            object = KeyEvent.getKeyModifiersText(8) + this.acceleratorDelimiter + (char)n3;
        }
        return object;
    }
}

