/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTMAxisIterator;
import com.sun.org.apache.xml.internal.dtm.DTMAxisTraverser;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.axes.ChildTestIterator;
import com.sun.org.apache.xpath.internal.axes.WalkerFactory;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import javax.xml.transform.TransformerException;

public class OneStepIterator
extends ChildTestIterator {
    protected int m_axis = -1;
    protected DTMAxisIterator m_iterator;

    OneStepIterator(Compiler compiler, int n2, int n3) throws TransformerException {
        super(compiler, n2, n3);
        int n4 = Compiler.getFirstChildPos(n2);
        this.m_axis = WalkerFactory.getAxisFromStep(compiler, n4);
    }

    public OneStepIterator(DTMAxisIterator dTMAxisIterator, int n2) throws TransformerException {
        super((DTMAxisTraverser)null);
        this.m_iterator = dTMAxisIterator;
        this.m_axis = n2;
        int n3 = -1;
        this.initNodeTest(n3);
    }

    public void setRoot(int n2, Object object) {
        super.setRoot(n2, object);
        if (this.m_axis > -1) {
            this.m_iterator = this.m_cdtm.getAxisIterator(this.m_axis);
        }
        this.m_iterator.setStartNode(this.m_context);
    }

    public void detach() {
        if (this.m_allowDetach) {
            if (this.m_axis > -1) {
                this.m_iterator = null;
            }
            super.detach();
        }
    }

    protected int getNextNode() {
        this.m_lastFetched = this.m_iterator.next();
        return this.m_lastFetched;
    }

    public Object clone() throws CloneNotSupportedException {
        OneStepIterator oneStepIterator = (OneStepIterator)super.clone();
        if (this.m_iterator != null) {
            oneStepIterator.m_iterator = this.m_iterator.cloneIterator();
        }
        return oneStepIterator;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        OneStepIterator oneStepIterator = (OneStepIterator)super.cloneWithReset();
        oneStepIterator.m_iterator = this.m_iterator;
        return oneStepIterator;
    }

    public boolean isReverseAxes() {
        return this.m_iterator.isReverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getProximityPosition(int n2) {
        if (!this.isReverseAxes()) {
            return super.getProximityPosition(n2);
        }
        if (n2 < 0) {
            return -1;
        }
        if (this.m_proximityPositions[n2] <= 0) {
            XPathContext xPathContext = this.getXPathContext();
            try {
                int n3;
                OneStepIterator oneStepIterator = (OneStepIterator)this.clone();
                int n4 = this.getRoot();
                xPathContext.pushCurrentNode(n4);
                oneStepIterator.setRoot(n4, xPathContext);
                oneStepIterator.m_predCount = n2;
                int n5 = 1;
                while (-1 != (n3 = oneStepIterator.nextNode())) {
                    ++n5;
                }
                int n6 = n2;
                this.m_proximityPositions[n6] = this.m_proximityPositions[n6] + n5;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
            finally {
                xPathContext.popCurrentNode();
            }
        }
        return this.m_proximityPositions[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() {
        if (!this.isReverseAxes()) {
            return super.getLength();
        }
        boolean bl2 = this == this.m_execContext.getSubContextList();
        int n2 = this.getPredicateCount();
        if (-1 != this.m_length && bl2 && this.m_predicateIndex < 1) {
            return this.m_length;
        }
        int n3 = 0;
        XPathContext xPathContext = this.getXPathContext();
        try {
            int n4;
            OneStepIterator oneStepIterator = (OneStepIterator)this.cloneWithReset();
            int n5 = this.getRoot();
            xPathContext.pushCurrentNode(n5);
            oneStepIterator.setRoot(n5, xPathContext);
            oneStepIterator.m_predCount = this.m_predicateIndex;
            while (-1 != (n4 = oneStepIterator.nextNode())) {
                ++n3;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
        }
        finally {
            xPathContext.popCurrentNode();
        }
        if (bl2 && this.m_predicateIndex < 1) {
            this.m_length = n3;
        }
        return n3;
    }

    protected void countProximityPosition(int n2) {
        if (!this.isReverseAxes()) {
            super.countProximityPosition(n2);
        } else if (n2 < this.m_proximityPositions.length) {
            int n3 = n2;
            this.m_proximityPositions[n3] = this.m_proximityPositions[n3] - 1;
        }
    }

    public void reset() {
        super.reset();
        if (null != this.m_iterator) {
            this.m_iterator.reset();
        }
    }

    public int getAxis() {
        return this.m_axis;
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        return this.m_axis == ((OneStepIterator)expression).m_axis;
    }
}

