/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.structurals;

import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.StructuralCodeConstraintException;
import com.sun.org.apache.bcel.internal.verifier.structurals.UninitializedObjectType;

public class LocalVariables {
    private Type[] locals;

    public LocalVariables(int n2) {
        this.locals = new Type[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.locals[i2] = Type.UNKNOWN;
        }
    }

    protected Object clone() {
        LocalVariables localVariables = new LocalVariables(this.locals.length);
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            localVariables.locals[i2] = this.locals[i2];
        }
        return localVariables;
    }

    public Type get(int n2) {
        return this.locals[n2];
    }

    public LocalVariables getClone() {
        return (LocalVariables)this.clone();
    }

    public int maxLocals() {
        return this.locals.length;
    }

    public void set(int n2, Type type) {
        if (type == Type.BYTE || type == Type.SHORT || type == Type.BOOLEAN || type == Type.CHAR) {
            throw new AssertionViolatedException("LocalVariables do not know about '" + type + "'. Use Type.INT instead.");
        }
        this.locals[n2] = type;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalVariables)) {
            return false;
        }
        LocalVariables localVariables = (LocalVariables)object;
        if (this.locals.length != localVariables.locals.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2].equals(localVariables.locals[i2])) continue;
            return false;
        }
        return true;
    }

    public void merge(LocalVariables localVariables) {
        if (this.locals.length != localVariables.locals.length) {
            throw new AssertionViolatedException("Merging LocalVariables of different size?!? From different methods or what?!?");
        }
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            this.merge(localVariables, i2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(LocalVariables localVariables, int n2) {
        if (!(this.locals[n2] instanceof UninitializedObjectType) && localVariables.locals[n2] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (!this.locals[n2].equals(localVariables.locals[n2]) && this.locals[n2] instanceof UninitializedObjectType && localVariables.locals[n2] instanceof UninitializedObjectType) {
            throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object in the local variables detected.");
        }
        if (this.locals[n2] instanceof UninitializedObjectType && !(localVariables.locals[n2] instanceof UninitializedObjectType)) {
            this.locals[n2] = ((UninitializedObjectType)this.locals[n2]).getInitialized();
        }
        if (this.locals[n2] instanceof ReferenceType && localVariables.locals[n2] instanceof ReferenceType) {
            if (this.locals[n2].equals(localVariables.locals[n2])) return;
            ReferenceType referenceType = ((ReferenceType)this.locals[n2]).firstCommonSuperclass((ReferenceType)localVariables.locals[n2]);
            if (referenceType == null) throw new AssertionViolatedException("Could not load all the super classes of '" + this.locals[n2] + "' and '" + localVariables.locals[n2] + "'.");
            this.locals[n2] = referenceType;
            return;
        } else {
            if (this.locals[n2].equals(localVariables.locals[n2])) return;
            this.locals[n2] = Type.UNKNOWN;
        }
    }

    public String toString() {
        String string = new String();
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            string = string + Integer.toString(i2) + ": " + this.locals[i2] + "\n";
        }
        return string;
    }

    public void initializeObject(UninitializedObjectType uninitializedObjectType) {
        for (int i2 = 0; i2 < this.locals.length; ++i2) {
            if (this.locals[i2] != uninitializedObjectType) continue;
            this.locals[i2] = uninitializedObjectType.getInitialized();
        }
    }
}

