/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ConnectionCache;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaConnectionCache;
import java.util.Collection;
import java.util.Iterator;

public abstract class CorbaConnectionCacheBase
implements ConnectionCache,
CorbaConnectionCache {
    protected ORB orb;
    protected long timestamp = 0L;
    protected String cacheType;
    protected String monitoringName;
    protected ORBUtilSystemException wrapper;

    protected CorbaConnectionCacheBase(ORB oRB, String string, String string2) {
        this.orb = oRB;
        this.cacheType = string;
        this.monitoringName = string2;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.transport");
        this.registerWithMonitoring();
        this.dprintCreation();
    }

    public String getCacheType() {
        return this.cacheType;
    }

    public synchronized void stampTime(Connection connection) {
        connection.setTimeStamp(this.timestamp++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberOfConnections() {
        Object object = this.backingStore();
        synchronized (object) {
            return this.values().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberOfIdleConnections() {
        long l2 = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                if (((Connection)iterator.next()).isBusy()) continue;
                ++l2;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long numberOfBusyConnections() {
        long l2 = 0L;
        Object object = this.backingStore();
        synchronized (object) {
            Iterator iterator = this.values().iterator();
            while (iterator.hasNext()) {
                if (!((Connection)iterator.next()).isBusy()) continue;
                ++l2;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean reclaim() {
        try {
            Object object;
            long l2 = this.numberOfConnections();
            if (this.orb.transportDebugFlag) {
                this.dprint(".reclaim->: " + l2 + " (" + this.orb.getORBData().getHighWaterMark() + "/" + this.orb.getORBData().getLowWaterMark() + "/" + this.orb.getORBData().getNumberToReclaim() + ")");
            }
            if (l2 <= (long)this.orb.getORBData().getHighWaterMark() || l2 < (long)this.orb.getORBData().getLowWaterMark()) {
                boolean bl2 = false;
                return bl2;
            }
            Object object2 = object = this.backingStore();
            synchronized (object2) {
                for (int i2 = 0; i2 < this.orb.getORBData().getNumberToReclaim(); ++i2) {
                    Connection connection = null;
                    long l3 = Long.MAX_VALUE;
                    for (Connection connection2 : this.values()) {
                        if (connection2.isBusy() || connection2.getTimeStamp() >= l3) continue;
                        connection = connection2;
                        l3 = connection2.getTimeStamp();
                    }
                    if (connection == null) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    try {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".reclaim: closing: " + connection);
                        }
                        connection.close();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.orb.transportDebugFlag) {
                    this.dprint(".reclaim: connections reclaimed (" + (l2 - this.numberOfConnections()) + ")");
                }
            }
            boolean bl4 = true;
            return bl4;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".reclaim<-: " + this.numberOfConnections());
            }
        }
    }

    public String getMonitoringName() {
        return this.monitoringName;
    }

    public abstract Collection values();

    protected abstract Object backingStore();

    protected abstract void registerWithMonitoring();

    protected void dprintCreation() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".constructor: cacheType: " + this.getCacheType() + " monitoringName: " + this.getMonitoringName());
        }
    }

    protected void dprintStatistics() {
        if (this.orb.transportDebugFlag) {
            this.dprint(".stats: " + this.numberOfConnections() + "/total " + this.numberOfBusyConnections() + "/busy " + this.numberOfIdleConnections() + "/idle" + " (" + this.orb.getORBData().getHighWaterMark() + "/" + this.orb.getORBData().getLowWaterMark() + "/" + this.orb.getORBData().getNumberToReclaim() + ")");
        }
    }

    protected void dprint(String string) {
        ORBUtility.dprint("CorbaConnectionCacheBase", string);
    }
}

