/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.SmartSecurityDialog;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.PrintService;

public final class PrintServiceImpl
implements PrintService {
    private static PrintServiceImpl _sharedInstance = null;
    private static SmartSecurityDialog _securityDialog = null;
    private PageFormat _pageFormat = null;

    private PrintServiceImpl() {
    }

    public static synchronized PrintServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new PrintServiceImpl();
        }
        return _sharedInstance;
    }

    public PageFormat getDefaultPage() {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob != null) {
            return (PageFormat)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return printerJob.defaultPage();
                }
            });
        }
        return null;
    }

    public PageFormat showPageFormatDialog(final PageFormat pageFormat) {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob != null) {
            return (PageFormat)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    PrintServiceImpl.this._pageFormat = printerJob.pageDialog(pageFormat);
                    return PrintServiceImpl.this._pageFormat;
                }
            });
        }
        return null;
    }

    public synchronized boolean print(Pageable pageable) {
        return this.doPrinting(null, pageable);
    }

    public synchronized boolean print(Printable printable) {
        return this.doPrinting(printable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doPrinting(final Printable printable, final Pageable pageable) {
        if (!this.askUser()) {
            return false;
        }
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (printerJob == null) {
            return false;
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (pageable != null) {
                    printerJob.setPageable(pageable);
                } else if (PrintServiceImpl.this._pageFormat == null) {
                    printerJob.setPrintable(printable);
                } else {
                    printerJob.setPrintable(printable, PrintServiceImpl.this._pageFormat);
                }
                if (printerJob.printDialog()) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                printerJob.print();
                            }
                            catch (PrinterException printerException) {
                                Trace.ignoredException((Exception)printerException);
                            }
                        }
                    });
                    thread.start();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        boolean bl2 = bl;
        return bl2;
    }

    private synchronized boolean askUser() {
        if (CheckServicePermission.hasPrintAccessPermissions()) {
            return true;
        }
        return PrintServiceImpl.requestPrintPermission();
    }

    public static boolean requestPrintPermission() {
        if (_securityDialog == null) {
            _securityDialog = new SmartSecurityDialog(ResourceManager.getString((String)"APIImpl.print.message"), true);
        }
        return _securityDialog.showDialog();
    }
}

