/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.interpreter.OopMapCacheEntry;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicObjectLock;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.MonitorInfo;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.StackValue;
import sun.jvm.hotspot.runtime.StackValueCollection;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public class InterpretedVFrame
extends JavaVFrame {
    public Method getMethod() {
        return this.getFrame().getInterpreterFrameMethod();
    }

    public StackValueCollection getLocals() {
        Method m = this.getMethod();
        int length = (int)m.getMaxLocals();
        if (m.isNative()) {
            length = (int)m.getSizeOfParameters();
        }
        StackValueCollection result = new StackValueCollection(length);
        OopMapCacheEntry oopMask = this.getMethod().getMaskFor(this.getBCI());
        for (int i = 0; i < length; ++i) {
            Address addr = this.addressOfLocalAt(i);
            StackValue sv = oopMask.isOop(i) ? new StackValue(addr.getOopHandleAt(0L)) : new StackValue(addr.getCIntegerAt(0L, VM.getVM().getAddressSize(), false));
            result.add(sv);
        }
        return result;
    }

    public StackValueCollection getExpressions() {
        int length = this.getFrame().getInterpreterFrameExpressionStackSize();
        if (this.getMethod().isNative()) {
            length = 0;
        }
        int nofLocals = (int)this.getMethod().getMaxLocals();
        StackValueCollection result = new StackValueCollection(length);
        OopMapCacheEntry oopMask = this.getMethod().getMaskFor(this.getBCI());
        for (int i = 0; i < length; ++i) {
            Address addr = this.addressOfExpressionStackAt(i);
            StackValue sv = oopMask.isOop(i + nofLocals) ? new StackValue(addr.getOopHandleAt(0L)) : new StackValue(addr.getCIntegerAt(0L, VM.getVM().getAddressSize(), false));
            result.add(sv);
        }
        return result;
    }

    public List getMonitors() {
        ArrayList<MonitorInfo> result = new ArrayList<MonitorInfo>(5);
        BasicObjectLock current = this.getFrame().interpreterFrameMonitorEnd();
        while (current.address().lessThan(this.getFrame().interpreterFrameMonitorBegin().address())) {
            result.add(new MonitorInfo(current.obj(), current.lock()));
            current = this.getFrame().nextMonitorInInterpreterFrame(current);
        }
        return result;
    }

    public boolean isInterpretedFrame() {
        return true;
    }

    InterpretedVFrame(Frame fr, RegisterMap regMap, JavaThread thread) {
        super(fr, regMap, thread);
    }

    public int getBCI() {
        return this.getFrame().getInterpreterFrameBCI();
    }

    public void verify() {
    }

    private Address addressOfLocalAt(int index) {
        Assert.that(this.getFrame().isInterpretedFrame(), "frame should be an interpreted frame");
        return this.fr.addressOfInterpreterFrameLocal(index);
    }

    private Address addressOfExpressionStackAt(int index) {
        return this.fr.addressOfInterpreterFrameExpressionStackSlot(index);
    }
}

