/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.management.OperatingSystemMXBean;
import java.awt.BorderLayout;
import java.io.IOException;
import java.lang.management.CompilationMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.VMPanel;

class VMTab
extends Tab
implements HyperlinkListener {
    JEditorPane info;
    private static final String cr = System.getProperty("line.separator");

    public static String getTabName() {
        return Resources.getText("VM", new Object[0]);
    }

    public VMTab(VMPanel vMPanel) {
        super(vMPanel, VMTab.getTabName());
        this.setLayout(new BorderLayout());
        this.info = new JEditorPane();
        this.info.setContentType("text/html");
        this.info.setEditable(false);
        this.info.addHyperlinkListener(this);
        ((DefaultCaret)this.info.getCaret()).setUpdatePolicy(1);
        this.add(new JScrollPane(this.info));
    }

    public void update() {
        final String string = this.formatText();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    VMTab.this.info.setText(string);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    String formatText() {
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (proxyClient.isDead()) {
            return "";
        }
        String string = "<html><table>";
        try {
            String string22;
            RuntimeMXBean runtimeMXBean = proxyClient.getRuntimeMXBean();
            CompilationMXBean compilationMXBean = proxyClient.getCompilationMXBean();
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = proxyClient.getOperatingSystemMXBean();
            String string3 = "<tr><td colspan=2><font size =-1><hr><tr><td colspan=2><font size =-1>";
            long l = runtimeMXBean.getUptime();
            string = string + "<tr><td colspan=2><center><b>" + Resources.getText("VM Information", new Object[0]) + "</b></center>";
            string = string + Formatter.newRow(Resources.getText("Java Virtual Machine", new Object[0]), runtimeMXBean.getVmName() + Resources.getText(" version ", new Object[0]) + runtimeMXBean.getVmVersion());
            string = string + Formatter.newRow(Resources.getText("Vendor", new Object[0]), runtimeMXBean.getVmVendor());
            string = string + Formatter.newRow(Resources.getText("Uptime", new Object[0]), Formatter.formatTime(l));
            string = string + Formatter.newRow(Resources.getText("Name", new Object[0]), runtimeMXBean.getName());
            String string4 = "";
            List<String> list = runtimeMXBean.getInputArguments();
            for (String string22 : list) {
                string4 = string4 + string22 + " ";
            }
            string = string + Formatter.newRow(Resources.getText("VM arguments", new Object[0]), string4);
            string = string + Formatter.newRow(Resources.getText("Class path", new Object[0]), runtimeMXBean.getClassPath());
            string = string + Formatter.newRow(Resources.getText("Library path", new Object[0]), runtimeMXBean.getLibraryPath());
            string = string + Formatter.newRow(Resources.getText("Boot class path", new Object[0]), runtimeMXBean.isBootClassPathSupported() ? runtimeMXBean.getBootClassPath() : Resources.getText("Unavailable", new Object[0]));
            string = string + string3;
            string = string + "<center><b>" + Resources.getText("Compiler", new Object[0]) + "</b></center>";
            string = string + Formatter.newRow(Resources.getText("JIT compiler", new Object[0]), compilationMXBean.getName());
            string = string + Formatter.newRow(Resources.getText("Total compile time", new Object[0]), compilationMXBean.isCompilationTimeMonitoringSupported() ? Formatter.formatTime(compilationMXBean.getTotalCompilationTime()) : Resources.getText("Unavailable", new Object[0]));
            string = string + string3;
            string = string + "<center><b>" + Resources.getText("Operating System", new Object[0]) + "</b></center>";
            String string5 = operatingSystemMXBean.getName();
            string22 = operatingSystemMXBean.getVersion();
            String string6 = operatingSystemMXBean.getArch();
            int n = operatingSystemMXBean.getAvailableProcessors();
            string = string + Formatter.newRow(Resources.getText("Operating System", new Object[0]), (String)string5 + " " + string22);
            string = string + Formatter.newRow(Resources.getText("Architecture", new Object[0]), string6);
            string = string + Formatter.newRow(Resources.getText("Number of processors", new Object[0]), n + "");
            OperatingSystemMXBean operatingSystemMXBean2 = proxyClient.getSunOperatingSystemMXBean();
            if (operatingSystemMXBean2 != null) {
                string = string + Formatter.newRow(Resources.getText("Process CPU time", new Object[0]), Formatter.formatNanoTime(operatingSystemMXBean2.getProcessCpuTime()));
                string = string + Formatter.newRow(Resources.getText("Total physical memory", new Object[0]), Formatter.formatKBytes(operatingSystemMXBean2.getTotalPhysicalMemorySize()));
                string = string + Formatter.newRow(Resources.getText("Free physical memory", new Object[0]), Formatter.formatKBytes(operatingSystemMXBean2.getFreePhysicalMemorySize()));
                string = string + Formatter.newRow(Resources.getText("Committed virtual memory", new Object[0]), Formatter.formatKBytes(operatingSystemMXBean2.getCommittedVirtualMemorySize()));
                string = string + Formatter.newRow(Resources.getText("Total swap space", new Object[0]), Formatter.formatKBytes(operatingSystemMXBean2.getTotalSwapSpaceSize()));
                string = string + Formatter.newRow(Resources.getText("Free swap space", new Object[0]), Formatter.formatKBytes(operatingSystemMXBean2.getFreeSwapSpaceSize()));
            }
        }
        catch (IOException iOException) {
            string = string + cr + iOException + cr;
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            string = string + cr + undeclaredThrowableException + cr;
            proxyClient.markAsDead();
        }
        return string;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = hyperlinkEvent.getDescription();
            this.vmPanel.setSelectedIndex(this.vmPanel.indexOfTab(string));
        }
    }
}

