/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.net.ssl.X509TrustManager;
import sun.security.validator.KeyStores;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;

final class X509TrustManagerImpl
implements X509TrustManager {
    private static final boolean checkRevocation = Debug.getBooleanProperty("com.sun.net.ssl.checkRevocation", false);
    private final String validatorType;
    private final Collection trustedCerts;
    private final PKIXBuilderParameters pkixParams;
    private volatile Validator clientValidator;
    private volatile Validator serverValidator;
    private static final Debug debug = Debug.getInstance("ssl");

    X509TrustManagerImpl(String string, KeyStore keyStore) throws KeyStoreException {
        this.validatorType = string;
        this.pkixParams = null;
        this.trustedCerts = keyStore == null ? Collections.EMPTY_SET : KeyStores.getTrustedCerts((KeyStore)keyStore);
        this.showTrustedCerts();
    }

    X509TrustManagerImpl(String string, PKIXBuilderParameters pKIXBuilderParameters) {
        this.validatorType = string;
        this.pkixParams = pKIXBuilderParameters;
        Validator validator = this.getValidator("tls server");
        this.trustedCerts = validator.getTrustedCertificates();
        this.serverValidator = validator;
        this.showTrustedCerts();
    }

    private void showTrustedCerts() {
        if (debug != null && Debug.isOn("trustmanager")) {
            Iterator iterator = this.trustedCerts.iterator();
            while (iterator.hasNext()) {
                System.out.println("adding as trusted cert:");
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                System.out.println("  Subject: " + x509Certificate.getSubjectX500Principal());
                System.out.println("  Issuer:  " + x509Certificate.getIssuerX500Principal());
                System.out.println("  Algorithm: " + x509Certificate.getPublicKey().getAlgorithm() + "; Serial number: 0x" + x509Certificate.getSerialNumber().toString(16));
                System.out.println("  Valid from " + x509Certificate.getNotBefore() + " until " + x509Certificate.getNotAfter());
                System.out.println();
            }
        }
    }

    private Validator getValidator(String string) {
        Validator validator;
        if (this.pkixParams == null) {
            validator = Validator.getInstance(this.validatorType, string, this.trustedCerts);
            if (validator instanceof PKIXValidator) {
                PKIXValidator pKIXValidator = (PKIXValidator)validator;
                pKIXValidator.getParameters().setRevocationEnabled(checkRevocation);
            }
        } else {
            validator = Validator.getInstance(this.validatorType, string, this.pkixParams);
        }
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        Validator validator = this.clientValidator;
        if (validator == null) {
            x509CertificateArray2 = this;
            // MONITORENTER : this
            validator = this.clientValidator;
            if (validator == null) {
                this.clientValidator = validator = super.getValidator("tls client");
            }
            // MONITOREXIT : x509CertificateArray2
        }
        x509CertificateArray2 = validator.validate(x509CertificateArray);
        if (debug == null) return;
        if (!Debug.isOn("trustmanager")) return;
        System.out.println("Found trusted certificate:");
        System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        Validator validator = this.serverValidator;
        if (validator == null) {
            x509CertificateArray2 = this;
            // MONITORENTER : this
            validator = this.serverValidator;
            if (validator == null) {
                this.serverValidator = validator = super.getValidator("tls server");
            }
            // MONITOREXIT : x509CertificateArray2
        }
        x509CertificateArray2 = validator.validate(x509CertificateArray, null, string);
        if (debug == null) return;
        if (!Debug.isOn("trustmanager")) return;
        System.out.println("Found trusted certificate:");
        System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.trustedCerts.size()];
        this.trustedCerts.toArray(x509CertificateArray);
        return x509CertificateArray;
    }
}

