/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.jvmstat.perfdata.monitor.protocol.local.PerfDataFile;

public class LocalVmManager {
    private String userName;
    private File tmpdir;
    private Pattern userPattern;
    private Matcher userMatcher;
    private FilenameFilter userFilter;
    private Pattern filePattern;
    private Matcher fileMatcher;
    private FilenameFilter fileFilter;
    private Pattern tmpFilePattern;
    private Matcher tmpFileMatcher;
    private FilenameFilter tmpFileFilter;

    public LocalVmManager() {
        this(null);
    }

    public LocalVmManager(String string) {
        this.userName = string;
        if (this.userName == null) {
            this.tmpdir = new File(PerfDataFile.getTempDirectory());
            this.userPattern = Pattern.compile("hsperfdata_\\S*");
            this.userMatcher = this.userPattern.matcher("");
            this.userFilter = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    LocalVmManager.this.userMatcher.reset(string);
                    return LocalVmManager.this.userMatcher.lookingAt();
                }
            };
        } else {
            this.tmpdir = new File(PerfDataFile.getTempDirectory(this.userName));
        }
        this.filePattern = Pattern.compile("^[0-9]+$");
        this.fileMatcher = this.filePattern.matcher("");
        this.fileFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                LocalVmManager.this.fileMatcher.reset(string);
                return LocalVmManager.this.fileMatcher.matches();
            }
        };
        this.tmpFilePattern = Pattern.compile("^hsperfdata_[0-9]+(_[1-2]+)?$");
        this.tmpFileMatcher = this.tmpFilePattern.matcher("");
        this.tmpFileFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                LocalVmManager.this.tmpFileMatcher.reset(string);
                return LocalVmManager.this.tmpFileMatcher.matches();
            }
        };
    }

    public synchronized Set activeVms() {
        int n;
        File[] fileArray;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.userName == null) {
            fileArray = this.tmpdir.listFiles(this.userFilter);
            for (n = 0; n < fileArray.length; ++n) {
                File[] fileArray2;
                if (!fileArray[n].isDirectory() || (fileArray2 = fileArray[n].listFiles(this.fileFilter)) == null) continue;
                for (int i = 0; i < fileArray2.length; ++i) {
                    if (!fileArray2[i].isFile() || !fileArray2[i].canRead()) continue;
                    hashSet.add(new Integer(PerfDataFile.getLocalVmId(fileArray2[i])));
                }
            }
        } else {
            if (!this.tmpdir.exists() || !this.tmpdir.isDirectory()) {
                return null;
            }
            fileArray = this.tmpdir.listFiles(this.fileFilter);
            if (fileArray != null) {
                for (n = 0; n < fileArray.length; ++n) {
                    if (!fileArray[n].isFile() || !fileArray[n].canRead()) continue;
                    hashSet.add(new Integer(PerfDataFile.getLocalVmId(fileArray[n])));
                }
            }
        }
        if ((fileArray = this.tmpdir.listFiles(this.tmpFileFilter)) != null) {
            for (n = 0; n < fileArray.length; ++n) {
                if (!fileArray[n].isFile() || !fileArray[n].canRead()) continue;
                hashSet.add(new Integer(PerfDataFile.getLocalVmId(fileArray[n])));
            }
        }
        return hashSet;
    }
}

