/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.util.FileEntry;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Warner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symbol {
    public int kind;
    public long flags_field;
    public List<Attribute.Compound> attributes_field;
    public Name name;
    public Type type;
    public Symbol owner;
    public Completer completer;
    public Type erasure_field;

    public long flags() {
        return this.flags_field;
    }

    public List<Attribute.Compound> attributes() {
        assert (this.attributes_field != null);
        return this.attributes_field;
    }

    public Attribute.Compound attribute(Symbol symbol) {
        for (Attribute.Compound compound : this.attributes()) {
            if (compound.type.tsym != symbol) continue;
            return compound;
        }
        return null;
    }

    public Symbol(int n, long l, Name name, Type type, Symbol symbol) {
        this.kind = n;
        this.flags_field = l;
        this.type = type;
        this.owner = symbol;
        this.completer = null;
        this.erasure_field = null;
        this.attributes_field = Attribute.Compound.emptyList;
        this.name = name;
    }

    public Symbol clone(Symbol symbol) {
        throw new AssertionError();
    }

    public String toString() {
        return this.name.toString();
    }

    public String location() {
        if (this.owner.name == null || this.owner.name.len == 0) {
            return "";
        }
        return this.owner.toString();
    }

    public String location(Type type, Types types) {
        Type type2;
        if (this.owner.name == null || this.owner.name.len == 0) {
            return "";
        }
        if (this.owner.type.tag == 10 && (type2 = types.asOuterSuper(type, this.owner)) != null) {
            return type2.toString();
        }
        return this.owner.toString();
    }

    public Type erasure(Types types) {
        if (this.erasure_field == null) {
            this.erasure_field = types.erasure(this.type);
        }
        return this.erasure_field;
    }

    public Type externalType(Types types) {
        Type type = this.erasure(types);
        if (this.name == this.name.table.init && this.owner.hasOuterInstance()) {
            Type type2 = types.erasure(this.owner.type.outer());
            return new Type.MethodType(type.argtypes().prepend(type2), type.restype(), type.thrown(), type.tsym);
        }
        return type;
    }

    public boolean isStatic() {
        return (this.flags() & 8L) != 0L || (this.owner.flags() & 0x200L) != 0L && this.kind != 16;
    }

    public boolean isLocal() {
        return (this.owner.kind & 0x14) != 0 || this.owner.kind == 2 && this.owner.isLocal();
    }

    public boolean isConstructor() {
        return this.name == this.name.table.init;
    }

    public Name fullName() {
        return this.name;
    }

    public Name flatName() {
        return this.fullName();
    }

    public Scope members() {
        return null;
    }

    public boolean isInner() {
        return this.type.outer().tag == 10;
    }

    public boolean hasOuterInstance() {
        return this.type.outer().tag == 10 && (this.flags() & 0x400200L) == 0L;
    }

    public ClassSymbol enclClass() {
        Symbol symbol = this;
        while (symbol != null && ((symbol.kind & 2) == 0 || symbol.type.tag != 10)) {
            symbol = symbol.owner;
        }
        return (ClassSymbol)symbol;
    }

    public ClassSymbol outermostClass() {
        Symbol symbol = this;
        Symbol symbol2 = null;
        while (symbol.kind != 1) {
            symbol2 = symbol;
            symbol = symbol.owner;
        }
        return (ClassSymbol)symbol2;
    }

    public PackageSymbol packge() {
        Symbol symbol = this;
        while (symbol.kind != 1) {
            symbol = symbol.owner;
        }
        return (PackageSymbol)symbol;
    }

    public boolean isSubClass(Symbol symbol, Types types) {
        throw new AssertionError((Object)("isSubClass " + this));
    }

    public boolean isMemberOf(TypeSymbol typeSymbol, Types types) {
        return this.owner == typeSymbol || typeSymbol.isSubClass(this.owner, types) && this.isInheritedIn(typeSymbol, types) && !this.hiddenIn((ClassSymbol)typeSymbol, types);
    }

    public boolean isEnclosedBy(ClassSymbol classSymbol) {
        Symbol symbol = this;
        while (symbol.kind != 1) {
            if (symbol == classSymbol) {
                return true;
            }
            symbol = symbol.owner;
        }
        return false;
    }

    private boolean hiddenIn(ClassSymbol classSymbol, Types types) {
        if (this.kind == 16 && (this.flags() & 8L) == 0L) {
            return false;
        }
        while (this.owner != classSymbol) {
            Scope.Entry entry = classSymbol.members().lookup(this.name);
            while (entry.scope != null) {
                if (entry.sym == this) {
                    return false;
                }
                if (entry.sym.kind == this.kind && (this.kind != 16 || (entry.sym.flags() & 8L) != 0L && types.isSubSignature(entry.sym.type, this.type))) {
                    return true;
                }
                entry = entry.next();
            }
            Type type = types.supertype(classSymbol.type);
            if (type.tag != 10) {
                return false;
            }
            classSymbol = (ClassSymbol)type.tsym;
        }
        return false;
    }

    public boolean isInheritedIn(Symbol symbol, Types types) {
        switch ((int)(this.flags_field & 7L)) {
            default: {
                return true;
            }
            case 2: {
                return this.owner == symbol;
            }
            case 4: {
                return (symbol.flags() & 0x200L) == 0L;
            }
            case 0: 
        }
        PackageSymbol packageSymbol = this.packge();
        Symbol symbol2 = symbol;
        while (symbol2 != null && symbol2 != this.owner) {
            if (symbol2.packge() != packageSymbol) {
                return false;
            }
            symbol2 = types.supertype((Type)symbol2.type).tsym;
        }
        return (symbol.flags() & 0x200L) == 0L;
    }

    public Symbol asMemberOf(Type type, Types types) {
        throw new AssertionError();
    }

    public boolean overrides(Symbol symbol, TypeSymbol typeSymbol, Types types, boolean bl) {
        return false;
    }

    public void complete() throws CompletionFailure {
        if (this.completer != null) {
            Completer completer = this.completer;
            this.completer = null;
            completer.complete(this);
        }
    }

    public boolean exists() {
        return true;
    }

    public static class ClassSymbol
    extends TypeSymbol {
        public Scope members_field = null;
        public Name fullname;
        public Name flatname;
        public Name sourcefile;
        public FileEntry classfile;
        public Pool pool;
        public static final List<ClassSymbol> emptyList = new List();

        public ClassSymbol(long l, Name name, Type type, Symbol symbol) {
            super(l, name, type, symbol);
            this.fullname = ClassSymbol.formFullName(name, symbol);
            this.flatname = ClassSymbol.formFlatName(name, symbol);
            this.sourcefile = null;
            this.classfile = null;
            this.pool = null;
        }

        public ClassSymbol(long l, Name name, Symbol symbol) {
            this(l, name, new Type.ClassType(Type.noType, null, null), symbol);
            this.type.tsym = this;
        }

        public String toString() {
            return this.className();
        }

        public long flags() {
            if (this.completer != null) {
                this.complete();
            }
            return this.flags_field;
        }

        public Scope members() {
            if (this.completer != null) {
                this.complete();
            }
            return this.members_field;
        }

        public Type erasure(Types types) {
            if (this.erasure_field == null) {
                this.erasure_field = new Type.ClassType(types.erasure(this.type.outer()), Type.emptyList, this);
            }
            return this.erasure_field;
        }

        public String className() {
            if (this.name.len == 0) {
                return Log.getLocalizedString("anonymous.class", this.flatname);
            }
            return this.fullname.toString();
        }

        public Name fullName() {
            return this.fullname;
        }

        public Name flatName() {
            return this.flatname;
        }

        public boolean isSubClass(Symbol symbol, Types types) {
            if (this == symbol) {
                return true;
            }
            if ((symbol.flags() & 0x200L) != 0L) {
                Type type = this.type;
                while (type.tag == 10) {
                    List<Type> list = types.interfaces(type);
                    while (list.nonEmpty()) {
                        if (((Type)list.head).tsym.isSubClass(symbol, types)) {
                            return true;
                        }
                        list = list.tail;
                    }
                    type = types.supertype(type);
                }
            } else {
                Type type = this.type;
                while (type.tag == 10) {
                    if (type.tsym == symbol) {
                        return true;
                    }
                    type = types.supertype(type);
                }
            }
            return false;
        }

        public boolean precedes(TypeSymbol typeSymbol, Types types) {
            return types.rank(typeSymbol.type) < types.rank(this.type) || types.rank(typeSymbol.type) == types.rank(this.type) && typeSymbol.fullName().compareTo(this.fullname) < 0;
        }

        public void complete() throws CompletionFailure {
            try {
                super.complete();
            }
            catch (CompletionFailure completionFailure) {
                this.flags_field |= 9L;
                this.type = new Type.ErrorType(this);
                throw completionFailure;
            }
        }
    }

    public static interface Completer {
        public void complete(Symbol var1) throws CompletionFailure;
    }

    public static class CompletionFailure
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        public Symbol sym;
        public String errmsg;

        public CompletionFailure(Symbol symbol, String string) {
            this.sym = symbol;
            this.errmsg = string;
        }

        public String getMessage() {
            return this.errmsg;
        }
    }

    public static class DelegatedSymbol
    extends Symbol {
        protected Symbol other;

        public DelegatedSymbol(Symbol symbol) {
            super(symbol.kind, symbol.flags_field, symbol.name, symbol.type, symbol.owner);
            this.other = symbol;
        }

        public String toString() {
            return this.other.toString();
        }

        public String location() {
            return this.other.location();
        }

        public String location(Type type, Types types) {
            return this.other.location(type, types);
        }

        public Type erasure(Types types) {
            return this.other.erasure(types);
        }

        public Type externalType(Types types) {
            return this.other.externalType(types);
        }

        public boolean isLocal() {
            return this.other.isLocal();
        }

        public boolean isConstructor() {
            return this.other.isConstructor();
        }

        public Name fullName() {
            return this.other.fullName();
        }

        public Name flatName() {
            return this.other.flatName();
        }

        public Scope members() {
            return this.other.members();
        }

        public boolean isInner() {
            return this.other.isInner();
        }

        public boolean hasOuterInstance() {
            return this.other.hasOuterInstance();
        }

        public ClassSymbol enclClass() {
            return this.other.enclClass();
        }

        public ClassSymbol outermostClass() {
            return this.other.outermostClass();
        }

        public PackageSymbol packge() {
            return this.other.packge();
        }

        public boolean isSubClass(Symbol symbol, Types types) {
            return this.other.isSubClass(symbol, types);
        }

        public boolean isMemberOf(TypeSymbol typeSymbol, Types types) {
            return this.other.isMemberOf(typeSymbol, types);
        }

        public boolean isEnclosedBy(ClassSymbol classSymbol) {
            return this.other.isEnclosedBy(classSymbol);
        }

        public boolean isInheritedIn(Symbol symbol, Types types) {
            return this.other.isInheritedIn(symbol, types);
        }

        public Symbol asMemberOf(Type type, Types types) {
            return this.other.asMemberOf(type, types);
        }

        public void complete() throws CompletionFailure {
            this.other.complete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodSymbol
    extends Symbol {
        public Code code = null;
        public List<VarSymbol> params = null;
        public Attribute defaultValue = null;
        public static final List<MethodSymbol> emptyList = new List();

        public MethodSymbol(long l, Name name, Type type, Symbol symbol) {
            super(16, l, name, type, symbol);
            assert (symbol.type.tag != 14) : symbol + "." + name;
        }

        @Override
        public MethodSymbol clone(Symbol symbol) {
            MethodSymbol methodSymbol = new MethodSymbol(this.flags_field, this.name, this.type, symbol);
            methodSymbol.code = this.code;
            return methodSymbol;
        }

        @Override
        public String toString() {
            String string;
            if ((this.flags() & 0x100000L) != 0L) {
                return this.owner.name.toString();
            }
            String string2 = string = this.name == this.name.table.init ? this.owner.name.toString() : this.name.toString();
            if (this.type != null) {
                if (this.type.tag == 16) {
                    string = "<" + ((Type.ForAll)this.type).typarams() + ">" + string;
                }
                string = string + "(" + this.type.argtypes((this.flags() & 0x400000000L) != 0L) + ")";
            }
            return string;
        }

        public Symbol implemented(TypeSymbol typeSymbol, Types types) {
            Symbol symbol = null;
            List<Type> list = types.interfaces(typeSymbol.type);
            while (symbol == null && list.nonEmpty()) {
                TypeSymbol typeSymbol2 = ((Type)list.head).tsym;
                Scope.Entry entry = typeSymbol2.members().lookup(this.name);
                while (symbol == null && entry.scope != null) {
                    if (this.overrides(entry.sym, (TypeSymbol)this.owner, types, true) && types.isSameType(this.type.restype(), types.memberType(this.owner.type, entry.sym).restype())) {
                        symbol = entry.sym;
                    }
                    if (symbol == null) {
                        symbol = this.implemented(typeSymbol2, types);
                    }
                    entry = entry.next();
                }
                list = list.tail;
            }
            return symbol;
        }

        public boolean binaryOverrides(Symbol symbol, TypeSymbol typeSymbol, Types types) {
            if (this.isConstructor() || symbol.kind != 16) {
                return false;
            }
            if (this == symbol) {
                return true;
            }
            MethodSymbol methodSymbol = (MethodSymbol)symbol;
            if (methodSymbol.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, methodSymbol.owner) != null && types.isSameType(this.erasure(types), methodSymbol.erasure(types))) {
                return true;
            }
            return (this.flags() & 0x400L) == 0L && methodSymbol.isOverridableIn(typeSymbol) && this.isMemberOf(typeSymbol, types) && types.isSameType(this.erasure(types), methodSymbol.erasure(types));
        }

        public MethodSymbol binaryImplementation(ClassSymbol classSymbol, Types types) {
            TypeSymbol typeSymbol = classSymbol;
            while (typeSymbol != null) {
                Scope.Entry entry = ((Symbol)typeSymbol).members().lookup(this.name);
                while (entry.scope != null) {
                    if (entry.sym.kind == 16 && ((MethodSymbol)entry.sym).binaryOverrides(this, classSymbol, types)) {
                        return (MethodSymbol)entry.sym;
                    }
                    entry = entry.next();
                }
                typeSymbol = types.supertype((Type)typeSymbol.type).tsym;
            }
            return null;
        }

        @Override
        public boolean overrides(Symbol symbol, TypeSymbol typeSymbol, Types types, boolean bl) {
            Type type;
            Type type2;
            if (this.isConstructor() || symbol.kind != 16) {
                return false;
            }
            if (this == symbol) {
                return true;
            }
            MethodSymbol methodSymbol = (MethodSymbol)symbol;
            if (methodSymbol.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, methodSymbol.owner) != null && types.isSubSignature(type2 = types.memberType(this.owner.type, this), type = types.memberType(this.owner.type, methodSymbol))) {
                if (!bl) {
                    return true;
                }
                if (types.returnTypeSubstitutable(type2, type)) {
                    return true;
                }
            }
            if ((this.flags() & 0x400L) != 0L || (methodSymbol.flags() & 0x400L) == 0L || !methodSymbol.isOverridableIn(typeSymbol) || !this.isMemberOf(typeSymbol, types)) {
                return false;
            }
            type2 = types.memberType(typeSymbol.type, this);
            return types.isSubSignature(type2, type = types.memberType(typeSymbol.type, methodSymbol)) && (!bl || types.resultSubtype(type2, type, Warner.noWarnings));
        }

        private boolean isOverridableIn(TypeSymbol typeSymbol) {
            switch ((int)(this.flags_field & 7L)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 4: {
                    return (typeSymbol.flags() & 0x200L) == 0L;
                }
                case 0: {
                    return this.packge() == typeSymbol.packge() && (typeSymbol.flags() & 0x200L) == 0L;
                }
            }
            return false;
        }

        public MethodSymbol implementation(TypeSymbol typeSymbol, Types types, boolean bl) {
            Type type = typeSymbol.type;
            while (type.tag == 10) {
                TypeSymbol typeSymbol2 = type.tsym;
                Scope.Entry entry = typeSymbol2.members().lookup(this.name);
                while (entry.scope != null) {
                    MethodSymbol methodSymbol;
                    if (entry.sym.kind == 16 && (methodSymbol = (MethodSymbol)entry.sym).overrides(this, typeSymbol, types, bl) && (methodSymbol.flags() & 0x1000L) == 0L) {
                        return methodSymbol;
                    }
                    entry = entry.next();
                }
                type = types.supertype(type);
            }
            if (types.isDerivedRaw(typeSymbol.type)) {
                return this.implementation(types.supertype((Type)typeSymbol.type).tsym, types, bl);
            }
            return null;
        }

        public List<VarSymbol> params() {
            this.owner.complete();
            if (this.params == null) {
                ListBuffer<VarSymbol> listBuffer = new ListBuffer<VarSymbol>();
                int n = 0;
                for (Type type : this.type.argtypes()) {
                    listBuffer.append(new VarSymbol(0x200000000L, this.name.table.fromString("arg" + n++), type, this));
                }
                this.params = listBuffer.toList();
            }
            return this.params;
        }

        @Override
        public Symbol asMemberOf(Type type, Types types) {
            return new MethodSymbol(this.flags_field, this.name, types.memberType(type, this), this.owner);
        }
    }

    public static class OperatorSymbol
    extends MethodSymbol {
        public int opcode;

        public OperatorSymbol(Name name, Type type, int n, Symbol symbol) {
            super(9L, name, type, symbol);
            this.opcode = n;
        }
    }

    public static class PackageSymbol
    extends TypeSymbol {
        public Scope members_field;
        public Name fullname;

        public PackageSymbol(Name name, Type type, Symbol symbol) {
            super(0L, name, type, symbol);
            this.kind = 1;
            this.members_field = null;
            this.fullname = PackageSymbol.formFullName(name, symbol);
        }

        public PackageSymbol(Name name, Symbol symbol) {
            this(name, null, symbol);
            this.type = new Type.PackageType(this);
        }

        public String toString() {
            return this.fullname.toString();
        }

        public Name fullName() {
            return this.fullname;
        }

        public Scope members() {
            if (this.completer != null) {
                this.complete();
            }
            return this.members_field;
        }

        public long flags() {
            if (this.completer != null) {
                this.complete();
            }
            return this.flags_field;
        }

        public boolean exists() {
            return (this.flags_field & 0x800000L) != 0L;
        }
    }

    public static class TypeSymbol
    extends Symbol {
        public TypeSymbol(long l, Name name, Type type, Symbol symbol) {
            super(2, l, name, type, symbol);
        }

        public String toString() {
            return this.name.toString();
        }

        public static Name formFullName(Name name, Symbol symbol) {
            if (symbol == null) {
                return name;
            }
            if (symbol.kind != 31 && ((symbol.kind & 0x14) != 0 || symbol.kind == 2 && symbol.type.tag == 14)) {
                return name;
            }
            Name name2 = symbol.fullName();
            if (name2 == null || name2 == name2.table.empty || name2 == name2.table.emptyPackage) {
                return name;
            }
            return name2.append('.', name);
        }

        public static Name formFlatName(Name name, Symbol symbol) {
            if (symbol == null || (symbol.kind & 0x14) != 0 || symbol.kind == 2 && symbol.type.tag == 14) {
                return name;
            }
            char c = symbol.kind == 2 ? (char)'$' : '.';
            Name name2 = symbol.flatName();
            if (name2 == null || name2 == name2.table.empty || name2 == name2.table.emptyPackage) {
                return name;
            }
            return name2.append(c, name);
        }

        public boolean precedes(TypeSymbol typeSymbol, Types types) {
            return this != typeSymbol;
        }
    }

    public static class VarSymbol
    extends Symbol {
        public int pos = 0;
        public int adr = -1;
        public Object constValue;
        public static final List<VarSymbol> emptyList = new List();

        public VarSymbol(long l, Name name, Type type, Symbol symbol) {
            super(4, l, name, type, symbol);
        }

        public VarSymbol clone(Symbol symbol) {
            VarSymbol varSymbol = new VarSymbol(this.flags_field, this.name, this.type, symbol);
            varSymbol.pos = this.pos;
            varSymbol.adr = this.adr;
            varSymbol.constValue = this.constValue;
            return varSymbol;
        }

        public String toString() {
            return this.name.toString();
        }

        public Symbol asMemberOf(Type type, Types types) {
            return new VarSymbol(this.flags_field, this.name, types.memberType(type, this), this.owner);
        }
    }
}

