/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.Utility;

public final class CompactCharArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 5;
    private static final int BLOCKCOUNT = 32;
    private static final int INDEXSHIFT = 11;
    private static final int INDEXCOUNT = 2048;
    private static final int BLOCKMASK = 31;
    private char[] values;
    private char[] indices;
    private int[] hashes;
    private boolean isCompact;
    private char defaultValue;

    public CompactCharArray() {
        this('\u0000');
    }

    public CompactCharArray(char c2) {
        int n2;
        this.values = new char[65536];
        this.indices = new char[2048];
        this.hashes = new int[2048];
        for (n2 = 0; n2 < 65536; ++n2) {
            this.values[n2] = c2;
        }
        for (n2 = 0; n2 < 2048; ++n2) {
            this.indices[n2] = (char)(n2 << 5);
            this.hashes[n2] = 0;
        }
        this.isCompact = false;
        this.defaultValue = c2;
    }

    public CompactCharArray(String string, String string2) {
        this(Utility.RLEStringToCharArray(string), Utility.RLEStringToCharArray(string2));
    }

    public CompactCharArray(char[] cArray, char[] cArray2) {
        if (cArray.length != 2048) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        for (int i2 = 0; i2 < 2048; ++i2) {
            char c2 = cArray[i2];
            if (c2 >= '\u0000' && c2 < cArray2.length + 32) continue;
            throw new IllegalArgumentException("Index out of bounds.");
        }
        this.indices = cArray;
        this.values = cArray2;
        this.isCompact = true;
    }

    public char elementAt(char c2) {
        return this.values[(this.indices[c2 >> 5] & 0xFFFF) + (c2 & 0x1F)];
    }

    public void setElementAt(char c2, char c3) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c2] = c3;
        this.touchBlock(c2 >> 5, c3);
    }

    public void setElementAt(char n2, char c2, char c3) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i2 = n2; i2 <= c2; ++i2) {
            this.values[i2] = c3;
            this.touchBlock(i2 >> 5, c3);
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 65535;
            int n5 = 0;
            while (n5 < this.indices.length) {
                this.indices[n5] = 65535;
                boolean bl2 = this.blockTouched(n5);
                if (!bl2 && n4 != 65535) {
                    this.indices[n5] = n4;
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.hashes[n5] == this.hashes[n7] && CompactCharArray.arrayRegionMatches(this.values, n3, this.values, n6, 32)) {
                            this.indices[n5] = (char)n6;
                        }
                        ++n7;
                        n6 += 32;
                    }
                    if (this.indices[n5] == '\uffff') {
                        System.arraycopy(this.values, n3, this.values, n6, 32);
                        this.indices[n5] = (char)n6;
                        this.hashes[n7] = this.hashes[n5];
                        ++n2;
                        if (!bl2) {
                            n4 = (char)n6;
                        }
                    }
                }
                ++n5;
                n3 += 32;
            }
            n5 = n2 * 32;
            char[] cArray = new char[n5];
            System.arraycopy(this.values, 0, cArray, 0, n5);
            this.values = cArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(char[] cArray, int n2, char[] cArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (cArray[i2] == cArray2[i2 + n6]) continue;
            return false;
        }
        return true;
    }

    private final void touchBlock(int n2, int n3) {
        this.hashes[n2] = this.hashes[n2] + (n3 << 1) | 1;
    }

    private final boolean blockTouched(int n2) {
        return this.hashes[n2] != 0;
    }

    public char[] getIndexArray() {
        return this.indices;
    }

    public char[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactCharArray compactCharArray = (CompactCharArray)super.clone();
            compactCharArray.values = (char[])this.values.clone();
            compactCharArray.indices = (char[])this.indices.clone();
            if (this.hashes != null) {
                compactCharArray.hashes = (int[])this.hashes.clone();
            }
            return compactCharArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactCharArray compactCharArray = (CompactCharArray)object;
        for (int i2 = 0; i2 < 65536; ++i2) {
            if (this.elementAt((char)i2) == compactCharArray.elementAt((char)i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = Math.min(3, this.values.length / 16);
        for (int i2 = 0; i2 < this.values.length; i2 += n3) {
            n2 = n2 * 37 + this.values[i2];
        }
        return n2;
    }

    private void expand() {
        if (this.isCompact) {
            int n2;
            char[] cArray = new char[65536];
            this.hashes = new int[2048];
            for (n2 = 0; n2 < 65536; ++n2) {
                char c2;
                cArray[n2] = c2 = this.elementAt((char)n2);
                this.touchBlock(n2 >> 5, c2);
            }
            for (n2 = 0; n2 < 2048; ++n2) {
                this.indices[n2] = (char)(n2 << 5);
            }
            this.values = null;
            this.values = cArray;
            this.isCompact = false;
        }
    }

    private char getArrayValue(int n2) {
        return this.values[n2];
    }

    private char getIndexArrayValue(int n2) {
        return this.indices[n2];
    }
}

