/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.lang.management.ThreadInfo;
import java.util.Map;
import java.util.TreeMap;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmThreadInstanceEntryImpl;
import sun.management.snmp.jvminstr.JvmThreadingImpl;
import sun.management.snmp.jvmmib.JvmThreadInstanceTableMeta;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;
import sun.management.snmp.util.SnmpCachedData;
import sun.management.snmp.util.SnmpTableCache;
import sun.management.snmp.util.SnmpTableHandler;

public class JvmThreadInstanceTableMetaImpl
extends JvmThreadInstanceTableMeta {
    public static final int MAX_STACK_TRACE_DEPTH = 0;
    protected SnmpTableCache cache;
    static final MibLogger log = new MibLogger(JvmThreadInstanceTableMetaImpl.class);

    static SnmpOid makeOid(long l2) {
        long[] lArray = new long[]{l2 >> 56 & 0xFFL, l2 >> 48 & 0xFFL, l2 >> 40 & 0xFFL, l2 >> 32 & 0xFFL, l2 >> 24 & 0xFFL, l2 >> 16 & 0xFFL, l2 >> 8 & 0xFFL, l2 & 0xFFL};
        return new SnmpOid(lArray);
    }

    static long makeId(SnmpOid snmpOid) {
        long l2 = 0L;
        long[] lArray = snmpOid.longValue(false);
        l2 |= lArray[0] << 56;
        l2 |= lArray[1] << 48;
        l2 |= lArray[2] << 40;
        l2 |= lArray[3] << 32;
        l2 |= lArray[4] << 24;
        l2 |= lArray[5] << 16;
        l2 |= lArray[6] << 8;
        return l2 |= lArray[7];
    }

    public JvmThreadInstanceTableMetaImpl(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        super(snmpMib, snmpStandardObjectServer);
        this.cache = new JvmThreadInstanceTableCache(this, ((JVM_MANAGEMENT_MIB_IMPL)snmpMib).validity());
        log.debug("JvmThreadInstanceTableMetaImpl", "Create Thread meta");
    }

    protected SnmpOid getNextOid(Object object) throws SnmpStatusException {
        log.debug("JvmThreadInstanceTableMetaImpl", "getNextOid");
        return this.getNextOid(null, object);
    }

    protected SnmpOid getNextOid(SnmpOid snmpOid, Object object) throws SnmpStatusException {
        log.debug("getNextOid", "previous=" + snmpOid);
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            log.debug("getNextOid", "handler is null!");
            throw new SnmpStatusException(224);
        }
        SnmpOid snmpOid2 = snmpOid;
        while ((snmpOid2 = snmpTableHandler.getNext(snmpOid2)) != null && this.getJvmThreadInstance(object, snmpOid2) == null) {
        }
        log.debug("*** **** **** **** getNextOid", "next=" + snmpOid2);
        if (snmpOid2 == null) {
            throw new SnmpStatusException(224);
        }
        return snmpOid2;
    }

    protected boolean contains(SnmpOid snmpOid, Object object) {
        SnmpTableHandler snmpTableHandler = this.getHandler(object);
        if (snmpTableHandler == null) {
            return false;
        }
        if (!snmpTableHandler.contains(snmpOid)) {
            return false;
        }
        JvmThreadInstanceEntryImpl jvmThreadInstanceEntryImpl = this.getJvmThreadInstance(object, snmpOid);
        return jvmThreadInstanceEntryImpl != null;
    }

    public Object getEntry(SnmpOid snmpOid) throws SnmpStatusException {
        log.debug("*** **** **** **** getEntry", "oid [" + snmpOid + "]");
        if (snmpOid == null || snmpOid.getLength() != 8) {
            log.debug("getEntry", "Invalid oid [" + snmpOid + "]");
            throw new SnmpStatusException(224);
        }
        Map map = JvmContextFactory.getUserData();
        SnmpTableHandler snmpTableHandler = this.getHandler(map);
        if (snmpTableHandler == null || !snmpTableHandler.contains(snmpOid)) {
            throw new SnmpStatusException(224);
        }
        JvmThreadInstanceEntryImpl jvmThreadInstanceEntryImpl = this.getJvmThreadInstance(map, snmpOid);
        if (jvmThreadInstanceEntryImpl == null) {
            throw new SnmpStatusException(224);
        }
        return jvmThreadInstanceEntryImpl;
    }

    protected SnmpTableHandler getHandler(Object object) {
        SnmpTableHandler snmpTableHandler;
        Map map = object instanceof Map ? (Map)object : null;
        if (map != null && (snmpTableHandler = (SnmpTableHandler)map.get("JvmThreadInstanceTable.handler")) != null) {
            return snmpTableHandler;
        }
        snmpTableHandler = this.cache.getTableHandler();
        if (map != null && snmpTableHandler != null) {
            map.put("JvmThreadInstanceTable.handler", snmpTableHandler);
        }
        return snmpTableHandler;
    }

    private ThreadInfo getThreadInfo(long l2) {
        return JvmThreadingImpl.getThreadMXBean().getThreadInfo(l2, 0);
    }

    private ThreadInfo getThreadInfo(SnmpOid snmpOid) {
        return this.getThreadInfo(JvmThreadInstanceTableMetaImpl.makeId(snmpOid));
    }

    private JvmThreadInstanceEntryImpl getJvmThreadInstance(Object object, SnmpOid snmpOid) {
        JvmThreadInstanceEntryImpl jvmThreadInstanceEntryImpl = null;
        String string = null;
        Map map = null;
        boolean bl2 = log.isDebugOn();
        if (object instanceof Map) {
            map = (Map)object;
            string = "JvmThreadInstanceTable.entry." + snmpOid.toString();
            jvmThreadInstanceEntryImpl = (JvmThreadInstanceEntryImpl)map.get(string);
        }
        if (jvmThreadInstanceEntryImpl != null) {
            if (bl2) {
                log.debug("*** getJvmThreadInstance", "Entry found in cache: " + string);
            }
            return jvmThreadInstanceEntryImpl;
        }
        if (bl2) {
            log.debug("*** getJvmThreadInstance", "Entry [" + snmpOid + "] is not in cache");
        }
        ThreadInfo threadInfo = null;
        try {
            threadInfo = this.getThreadInfo(snmpOid);
        }
        catch (RuntimeException runtimeException) {
            log.trace("*** getJvmThreadInstance", "Failed to get thread info for rowOid: " + snmpOid);
            log.debug("*** getJvmThreadInstance", runtimeException);
        }
        if (threadInfo == null) {
            if (bl2) {
                log.debug("*** getJvmThreadInstance", "No entry by that oid [" + snmpOid + "]");
            }
            return null;
        }
        jvmThreadInstanceEntryImpl = new JvmThreadInstanceEntryImpl(threadInfo, snmpOid.toByte());
        if (map != null) {
            map.put(string, jvmThreadInstanceEntryImpl);
        }
        if (bl2) {
            log.debug("*** getJvmThreadInstance", "Entry created for Thread OID [" + snmpOid + "]");
        }
        return jvmThreadInstanceEntryImpl;
    }

    private static class JvmThreadInstanceTableCache
    extends SnmpTableCache {
        private final JvmThreadInstanceTableMetaImpl meta;

        JvmThreadInstanceTableCache(JvmThreadInstanceTableMetaImpl jvmThreadInstanceTableMetaImpl, long l2) {
            this.validity = l2;
            this.meta = jvmThreadInstanceTableMetaImpl;
        }

        public SnmpTableHandler getTableHandler() {
            Map map = JvmContextFactory.getUserData();
            return this.getTableDatas(map);
        }

        protected SnmpCachedData updateCachedDatas(Object object) {
            long[] lArray = JvmThreadingImpl.getThreadMXBean().getAllThreadIds();
            long l2 = System.currentTimeMillis();
            SnmpOid[] snmpOidArray = new SnmpOid[lArray.length];
            TreeMap<SnmpOid, SnmpOid> treeMap = new TreeMap<SnmpOid, SnmpOid>(SnmpCachedData.oidComparator);
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                log.debug("", "Making index for thread id [" + lArray[i2] + "]");
                SnmpOid snmpOid = JvmThreadInstanceTableMetaImpl.makeOid(lArray[i2]);
                treeMap.put(snmpOid, snmpOid);
            }
            return new SnmpCachedData(l2, treeMap);
        }
    }
}

