/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;

public final class RenderCache {
    private Entry[] entries;

    public RenderCache(int n2) {
        this.entries = new Entry[n2];
    }

    public synchronized Object get(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        int n2;
        Entry entry;
        for (int i2 = n2 = this.entries.length - 1; i2 >= 0 && (entry = this.entries[i2]) != null; --i2) {
            if (!entry.matches(surfaceType, compositeType, surfaceType2)) continue;
            if (i2 < n2 - 4) {
                System.arraycopy(this.entries, i2 + 1, this.entries, i2, n2 - i2);
                this.entries[n2] = entry;
            }
            return entry.getValue();
        }
        return null;
    }

    public synchronized void put(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2, Object object) {
        Entry entry = new Entry(surfaceType, compositeType, surfaceType2, object);
        int n2 = this.entries.length;
        System.arraycopy(this.entries, 1, this.entries, 0, n2 - 1);
        this.entries[n2 - 1] = entry;
    }

    final class Entry {
        private SurfaceType src;
        private CompositeType comp;
        private SurfaceType dst;
        private Object value;

        public Entry(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2, Object object) {
            this.src = surfaceType;
            this.comp = compositeType;
            this.dst = surfaceType2;
            this.value = object;
        }

        public boolean matches(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
            return this.src == surfaceType && this.comp == compositeType && this.dst == surfaceType2;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

