/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.MergeCollation;
import java.text.ParseException;
import java.text.PatternEntry;
import java.text.RBCollationTables;
import java.util.Vector;
import sun.text.ComposedCharIter;
import sun.text.IntHashtable;
import sun.text.NormalizerImpl;
import sun.text.UCompactIntArray;

final class RBTableBuilder {
    static final int CHARINDEX = 0x70000000;
    private static final int IGNORABLEMASK = 65535;
    private static final int PRIMARYORDERINCREMENT = 65536;
    private static final int SECONDARYORDERINCREMENT = 256;
    private static final int TERTIARYORDERINCREMENT = 1;
    private static final int INITIALTABLESIZE = 20;
    private static final int MAXKEYSIZE = 5;
    private RBCollationTables.BuildAPI tables = null;
    private MergeCollation mPattern = null;
    private boolean isOverIgnore = false;
    private char[] keyBuf = new char[5];
    private IntHashtable contractFlags = new IntHashtable(100);
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private UCompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    public RBTableBuilder(RBCollationTables.BuildAPI buildAPI) {
        this.tables = buildAPI;
    }

    public void build(String string, int n2) throws ParseException {
        boolean bl2 = true;
        int n3 = 0;
        if (string.length() == 0) {
            throw new ParseException("Build rules empty.", 0);
        }
        this.mapping = new UCompactIntArray(-1);
        string = NormalizerImpl.canonicalDecomposeWithSingleQuotation(string);
        this.mPattern = new MergeCollation(string);
        int n4 = 0;
        for (n3 = 0; n3 < this.mPattern.getCount(); ++n3) {
            char c2;
            PatternEntry patternEntry = this.mPattern.getItemAt(n3);
            if (patternEntry == null) continue;
            String string2 = patternEntry.getChars();
            if (string2.length() > 1) {
                switch (string2.charAt(string2.length() - 1)) {
                    case '@': {
                        this.frenchSec = true;
                        string2 = string2.substring(0, string2.length() - 1);
                        break;
                    }
                    case '!': {
                        this.seAsianSwapping = true;
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                }
            }
            n4 = this.increment(patternEntry.getStrength(), n4);
            String string3 = patternEntry.getExtension();
            if (string3.length() != 0) {
                this.addExpandOrder(string2, string3, n4);
                continue;
            }
            if (string2.length() > 1) {
                c2 = string2.charAt(0);
                if (Character.isHighSurrogate(c2) && string2.length() == 2) {
                    this.addOrder(Character.toCodePoint(c2, string2.charAt(1)), n4);
                    continue;
                }
                this.addContractOrder(string2, n4);
                continue;
            }
            c2 = string2.charAt(0);
            this.addOrder(c2, n4);
        }
        this.addComposedChars();
        this.commit();
        this.mapping.compact();
        this.tables.fillInTables(this.frenchSec, this.seAsianSwapping, this.mapping, this.contractTable, this.expandTable, this.contractFlags, this.maxSecOrder, this.maxTerOrder);
    }

    private void addComposedChars() throws ParseException {
        int n2;
        ComposedCharIter composedCharIter = new ComposedCharIter();
        while ((n2 = composedCharIter.next()) != -1) {
            int n3;
            int n4;
            if (this.getCharOrder(n2) != -1) continue;
            String string = composedCharIter.decomposition();
            if (string.length() == 1) {
                n4 = this.getCharOrder(string.charAt(0));
                if (n4 == -1) continue;
                this.addOrder(n2, n4);
                continue;
            }
            if (string.length() == 2 && Character.isHighSurrogate((char)(n4 = (int)string.charAt(0)))) {
                n3 = this.getCharOrder(string.codePointAt(0));
                if (n3 == -1) continue;
                this.addOrder(n2, n3);
                continue;
            }
            n4 = this.getContractOrder(string);
            if (n4 != -1) {
                this.addOrder(n2, n4);
                continue;
            }
            n3 = 1;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (this.getCharOrder(string.charAt(i2)) != -1) continue;
                n3 = 0;
                break;
            }
            if (n3 == 0) continue;
            this.addExpandOrder(n2, string, -1);
        }
    }

    private final void commit() {
        if (this.expandTable != null) {
            for (int i2 = 0; i2 < this.expandTable.size(); ++i2) {
                int[] nArray = (int[])this.expandTable.elementAt(i2);
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    int n2 = nArray[i3];
                    if (n2 >= 0x7E000000 || n2 <= 0x70000000) continue;
                    int n3 = n2 - 0x70000000;
                    int n4 = this.getCharOrder(n3);
                    nArray[i3] = n4 == -1 ? 0xFFFF & n3 : n4;
                }
            }
        }
    }

    private final int increment(int n2, int n3) {
        switch (n2) {
            case 0: {
                n3 += 65536;
                n3 &= 0xFFFF0000;
                this.isOverIgnore = true;
                break;
            }
            case 1: {
                n3 += 256;
                n3 &= 0xFFFFFF00;
                if (this.isOverIgnore) break;
                this.maxSecOrder = (short)(this.maxSecOrder + 1);
                break;
            }
            case 2: {
                ++n3;
                if (this.isOverIgnore) break;
                this.maxTerOrder = (short)(this.maxTerOrder + 1);
            }
        }
        return n3;
    }

    private final void addOrder(int n2, int n3) {
        int n4 = this.mapping.elementAt(n2);
        if (n4 >= 0x7F000000) {
            int n5 = 1;
            if (Character.isSupplementaryCodePoint(n2)) {
                n5 = Character.toChars(n2, this.keyBuf, 0);
            } else {
                this.keyBuf[0] = (char)n2;
            }
            this.addContractOrder(new String(this.keyBuf, 0, n5), n3);
        } else {
            this.mapping.setElementAt(n2, n3);
        }
    }

    private final void addContractOrder(String string, int n2) {
        this.addContractOrder(string, n2, true);
    }

    private final void addContractOrder(String string, int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        Vector<EntryPair> vector;
        if (this.contractTable == null) {
            this.contractTable = new Vector(20);
        }
        if ((vector = this.getContractValuesImpl((n5 = this.mapping.elementAt(n4 = string.codePointAt(0))) - 0x7F000000)) == null) {
            n3 = 0x7F000000 + this.contractTable.size();
            vector = new Vector<EntryPair>(20);
            this.contractTable.addElement(vector);
            vector.addElement(new EntryPair(string.substring(0, Character.charCount(n4)), n5));
            this.mapping.setElementAt(n4, n3);
        }
        if ((n3 = RBCollationTables.getEntry(vector, string, bl2)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n3);
            entryPair.value = n2;
        } else {
            EntryPair entryPair = (EntryPair)vector.lastElement();
            if (string.length() > entryPair.entryName.length()) {
                vector.addElement(new EntryPair(string, n2, bl2));
            } else {
                vector.insertElementAt(new EntryPair(string, n2, bl2), vector.size() - 1);
            }
        }
        if (bl2 && string.length() > 1) {
            this.addContractFlags(string);
            this.addContractOrder(new StringBuffer(string).reverse().toString(), n2, false);
        }
    }

    private int getContractOrder(String string) {
        int n2;
        int n3;
        Vector vector;
        int n4 = -1;
        if (this.contractTable != null && (vector = this.getContractValues(n3 = string.codePointAt(0))) != null && (n2 = RBCollationTables.getEntry(vector, string, true)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n2);
            n4 = entryPair.value;
        }
        return n4;
    }

    private final int getCharOrder(int n2) {
        int n3 = this.mapping.elementAt(n2);
        if (n3 >= 0x7F000000) {
            Vector vector = this.getContractValuesImpl(n3 - 0x7F000000);
            EntryPair entryPair = (EntryPair)vector.firstElement();
            n3 = entryPair.value;
        }
        return n3;
    }

    private Vector getContractValues(int n2) {
        int n3 = this.mapping.elementAt(n2);
        return this.getContractValuesImpl(n3 - 0x7F000000);
    }

    private Vector getContractValuesImpl(int n2) {
        if (n2 >= 0) {
            return (Vector)this.contractTable.elementAt(n2);
        }
        return null;
    }

    private final void addExpandOrder(String string, String string2, int n2) throws ParseException {
        int n3 = this.addExpansion(n2, string2);
        if (string.length() > 1) {
            char c2 = string.charAt(0);
            if (Character.isHighSurrogate(c2) && string.length() == 2) {
                char c3 = string.charAt(1);
                if (Character.isLowSurrogate(c3)) {
                    this.addOrder(Character.toCodePoint(c2, c3), n3);
                }
            } else {
                this.addContractOrder(string, n3);
            }
        } else {
            this.addOrder(string.charAt(0), n3);
        }
    }

    private final void addExpandOrder(int n2, String string, int n3) throws ParseException {
        int n4 = this.addExpansion(n3, string);
        this.addOrder(n2, n4);
    }

    private int addExpansion(int n2, String string) {
        if (this.expandTable == null) {
            this.expandTable = new Vector(20);
        }
        int n3 = n2 == -1 ? 0 : 1;
        int[] nArray = new int[string.length() + n3];
        if (n3 == 1) {
            nArray[0] = n2;
        }
        int n4 = n3;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n5;
            int n6 = string.charAt(i2);
            if (Character.isHighSurrogate((char)n6)) {
                char c2;
                if (++i2 == string.length() || !Character.isLowSurrogate(c2 = string.charAt(i2))) break;
                n5 = Character.toCodePoint((char)n6, c2);
            } else {
                n5 = n6;
            }
            int n7 = this.getCharOrder(n5);
            nArray[n4++] = n7 != -1 ? n7 : 0x70000000 + n5;
        }
        if (n4 < nArray.length) {
            int[] nArray2 = new int[n4];
            while (--n4 >= 0) {
                nArray2[n4] = nArray[n4];
            }
            nArray = nArray2;
        }
        int n8 = 0x7E000000 + this.expandTable.size();
        this.expandTable.addElement(nArray);
        return n8;
    }

    private void addContractFlags(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = string.charAt(i2);
            int n4 = Character.isHighSurrogate((char)n3) ? Character.toCodePoint((char)n3, string.charAt(++i2)) : n3;
            this.contractFlags.put(n4, 1);
        }
    }
}

