/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.HeapFloatBuffer;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FloatBuffer
extends Buffer
implements Comparable<FloatBuffer> {
    final float[] hb;
    final int offset;
    boolean isReadOnly;

    FloatBuffer(int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        super(n2, n3, n4, n5);
        this.hb = fArray;
        this.offset = n6;
    }

    FloatBuffer(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, null, 0);
    }

    public static FloatBuffer allocate(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        return new HeapFloatBuffer(n2, n2);
    }

    public static FloatBuffer wrap(float[] fArray, int n2, int n3) {
        try {
            return new HeapFloatBuffer(fArray, n2, n3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static FloatBuffer wrap(float[] fArray) {
        return FloatBuffer.wrap(fArray, 0, fArray.length);
    }

    public abstract FloatBuffer slice();

    public abstract FloatBuffer duplicate();

    public abstract FloatBuffer asReadOnlyBuffer();

    public abstract float get();

    public abstract FloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract FloatBuffer put(int var1, float var2);

    public FloatBuffer get(float[] fArray, int n2, int n3) {
        FloatBuffer.checkBounds(n2, n3, fArray.length);
        if (n3 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            fArray[i2] = this.get();
        }
        return this;
    }

    public FloatBuffer get(float[] fArray) {
        return this.get(fArray, 0, fArray.length);
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n2 = floatBuffer.remaining();
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.put(floatBuffer.get());
        }
        return this;
    }

    public FloatBuffer put(float[] fArray, int n2, int n3) {
        FloatBuffer.checkBounds(n2, n3, fArray.length);
        if (n3 > this.remaining()) {
            throw new BufferOverflowException();
        }
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.put(fArray[i2]);
        }
        return this;
    }

    public final FloatBuffer put(float[] fArray) {
        return this.put(fArray, 0, fArray.length);
    }

    public final boolean hasArray() {
        return this.hb != null && !this.isReadOnly;
    }

    public final float[] array() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.hb;
    }

    public final int arrayOffset() {
        if (this.hb == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.offset;
    }

    public abstract FloatBuffer compact();

    public abstract boolean isDirect();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[pos=");
        stringBuffer.append(this.position());
        stringBuffer.append(" lim=");
        stringBuffer.append(this.limit());
        stringBuffer.append(" cap=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n2 = 1;
        int n3 = this.position();
        for (int i2 = this.limit() - 1; i2 >= n3; --i2) {
            n2 = 31 * n2 + (int)this.get(i2);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FloatBuffer)) {
            return false;
        }
        FloatBuffer floatBuffer = (FloatBuffer)object;
        if (this.remaining() != floatBuffer.remaining()) {
            return false;
        }
        int n2 = this.position();
        int n3 = this.limit() - 1;
        int n4 = floatBuffer.limit() - 1;
        while (n3 >= n2) {
            float f2;
            float f3 = this.get(n3);
            if (f3 != (f2 = floatBuffer.get(n4)) && (f3 == f3 || f2 == f2)) {
                return false;
            }
            --n3;
            --n4;
        }
        return true;
    }

    @Override
    public int compareTo(FloatBuffer floatBuffer) {
        int n2 = this.position() + Math.min(this.remaining(), floatBuffer.remaining());
        int n3 = this.position();
        int n4 = floatBuffer.position();
        while (n3 < n2) {
            float f2;
            float f3 = this.get(n3);
            if (f3 != (f2 = floatBuffer.get(n4)) && (f3 == f3 || f2 == f2)) {
                if (f3 < f2) {
                    return -1;
                }
                return 1;
            }
            ++n3;
            ++n4;
        }
        return this.remaining() - floatBuffer.remaining();
    }

    public abstract ByteOrder order();
}

