/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001-2003 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#include "settings.h"
#include "resources.h"

#include <qstring.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstandarddirs.h>

const bool Defaults::Editor::autoUnsetFuzzy=true;
const bool Defaults::Editor::beepOnError=false;
const bool Defaults::Editor::autoCheckColorError=true;

const bool Defaults::Editor::cleverEditing=true;
const bool Defaults::Editor::highlightBg=false;
const bool Defaults::Editor::whitespacePoints=true;
const bool Defaults::Editor::quotes=false;
const bool Defaults::Editor::highlightSyntax=true;

const bool Defaults::Editor::ledInStatusbar=false;

const QColor Defaults::Editor::bgColor=QColor(255,255,192);
const QColor Defaults::Editor::quotedColor=QColor(Qt::darkGreen);
const QColor Defaults::Editor::errorColor=QColor(Qt::red);
const QColor Defaults::Editor::cformatColor=QColor(Qt::blue);
const QColor Defaults::Editor::accelColor=QColor(Qt::darkMagenta);
const QColor Defaults::Editor::tagColor=QColor(Qt::darkBlue);
const QColor Defaults::Editor::ledColor=QColor(Qt::red);
const QColor Defaults::Editor::diffAddColor=QColor(192,192,255);
const QColor Defaults::Editor::diffDelColor=QColor(255,128,128);
const QString Defaults::Editor::diffBaseDir=QString::null;
const bool Defaults::Editor::diffAddUnderline=false;
const bool Defaults::Editor::diffDelStrikeOut=false;
const EditorSettings::DiffSource Defaults::Editor::diffSource=EditorSettings::File;

const bool Defaults::Spellcheck::rememberIgnored=true;
QString Defaults::Spellcheck::_ignoreURL=QString::null;
const bool Defaults::Spellcheck::onFlySpellcheck=true;

QFont Defaults::Editor::msgFont()
{
   return KGlobalSettings::generalFont();
}

QString Defaults::Spellcheck::ignoreURL()
{
	if(_ignoreURL.isEmpty())
	{
		KStandardDirs * dirs = KGlobal::dirs();
		if(dirs)
		{
			_ignoreURL = dirs->saveLocation("appdata");
			if(_ignoreURL.right(1)!="/")
				_ignoreURL+="/";
			_ignoreURL += "spellignores";
		}
	}

	return _ignoreURL;
}

QStringList Defaults::Editor::autoCheckTools()
{
    return QStringList();
}

const QString Defaults::Search::defaultModule="pocompendium";
const bool Defaults::Search::autoSearch=false;
