/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2003	  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#include "catalogmanagerpref.h"
#include "prefwidgets.h"
#include "settings.h"

#include <qlayout.h>
#include <qwhatsthis.h>
#include <qvbox.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kapplication.h>


#define PAGE_CATMAN       0
#define PAGE_DIRCOMMANDS  1
#define PAGE_FILECOMMANDS 2
#define PAGE_VIEW	  3

CatalogManagerPreferences::CatalogManagerPreferences(CatManSettings catmanOpts)
    : KDialogBase(IconList, i18n("Preferences"),
                  Help|Default|Ok|Apply|Cancel, Ok,0,0,false)
{
//    setIconListAllVisible(true);

    QVBox *frame;
    frame = addVBoxPage(i18n("title of page in preferences dialog","General")
               , i18n("Paths to Message Catalogs & Catalog Templates")
               ,BarIcon("catalogmanager",32));
    _generalPage = new GeneralPreferences(frame);
    _generalPage->setSettings(catmanOpts);

    frame = addVBoxPage(i18n("title of page in preferences dialog","Folders")
               , i18n("User-Defined Commands for Folder Items")
               ,DesktopIcon("folder",32));
    _dirCommandsPage = new DirCommandsPreferences(frame);
    _dirCommandsPage->setSettings(catmanOpts);

    frame = addVBoxPage(i18n("title of page in preferences dialog","Files")
               , i18n("User-Defined Commands for File Items")
               ,DesktopIcon("files",32));
    _fileCommandsPage = new FileCommandsPreferences(frame);
    _fileCommandsPage->setSettings(catmanOpts);

    frame = addVBoxPage(i18n("title of page in preferences dialog","View")
               , i18n("View Settings")
               ,DesktopIcon("view_tree",32));
    _viewPage = new ViewPreferences(frame);
    _viewPage->setSettings(catmanOpts);

    adjustSize();

    _catmanSettings = catmanOpts;
}


void CatalogManagerPreferences::updateCatManSettings(CatManSettings settings)
{
    _generalPage->setSettings(settings);
    _dirCommandsPage->setSettings(settings);
    _fileCommandsPage->setSettings(settings);
    _viewPage->setSettings(settings);
    _catmanSettings=settings;
}

void CatalogManagerPreferences::slotHelp()
{
   //TODO
   kapp->invokeHTMLHelp("Preferences","");
}

void CatalogManagerPreferences::slotDefault()
{
   switch(activePageIndex())
   {
      case PAGE_CATMAN:
         _generalPage->defaults();
         break;
      case PAGE_DIRCOMMANDS:
         _dirCommandsPage->defaults();
         break;
      case PAGE_FILECOMMANDS:
         _fileCommandsPage->defaults();
         break;
      case PAGE_VIEW:
         _viewPage->defaults();
         break;
      default:
        break;
   }
}

void CatalogManagerPreferences::slotApply()
{
   QStringList list;

   switch(activePageIndex())
   {
      case PAGE_CATMAN:
         _generalPage->mergeSettings(_catmanSettings);
         emit catmanOptionsChanged(_catmanSettings);
         break;
      case PAGE_DIRCOMMANDS:
         _dirCommandsPage->mergeSettings(_catmanSettings);
         emit catmanOptionsChanged(_catmanSettings);
         break;
      case PAGE_FILECOMMANDS:
         _fileCommandsPage->mergeSettings(_catmanSettings);
         emit catmanOptionsChanged(_catmanSettings);
         break;
      case PAGE_VIEW:
         _viewPage->mergeSettings(_catmanSettings);
         emit catmanOptionsChanged(_catmanSettings);
         break;
      default:
        break;
   }

}

void CatalogManagerPreferences::slotOk()
{
   _generalPage->mergeSettings(_catmanSettings);
   _dirCommandsPage->mergeSettings(_catmanSettings);
   _fileCommandsPage->mergeSettings(_catmanSettings);
   _viewPage->mergeSettings(_catmanSettings);

   emit catmanOptionsChanged(_catmanSettings);

   QDialog::accept();
}

void CatalogManagerPreferences::slotCancel()
{
    _generalPage->setSettings(_catmanSettings);
    _dirCommandsPage->setSettings(_catmanSettings);
    _fileCommandsPage->setSettings(_catmanSettings);
    _viewPage->setSettings(_catmanSettings);

    QDialog::reject();
}

void CatalogManagerPreferences::mergeSettings(CatManSettings& settings)
{
    _generalPage->mergeSettings(settings);
    _dirCommandsPage->mergeSettings(settings);
    _fileCommandsPage->mergeSettings(settings);
    _viewPage->mergeSettings(settings);
}

#include "catalogmanagerpref.moc"
