/* SysInfo-factory.cc                      KPilot
**
** Copyright (C) 2003 by Reinhold Kainhofer
**
** This file defines the factory for the SysInfo-conduit plugin.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
** MA 02111-1307, USA.
*/

/*
** Bug reports and questions can be sent to kde-pim@kde.org
*/

#include "options.h"

#include <kapplication.h>
#include <kinstance.h>
#include <kaboutdata.h>

#include "sysinfo-conduit.h"
#include "sysinfo-setup.h"

#include "sysinfo-factory.moc"


extern "C"
{

void *init_conduit_sysinfo()
{
	return new SysInfoConduitFactory;
}

}


// A number of static variables; except for fAbout, they're
// all KConfig group or entry keys.
//
//
KAboutData *SysInfoConduitFactory::fAbout = 0L;
const char *SysInfoConduitFactory::fGroup = "SysInfo-conduit";
const char *SysInfoConduitFactory::fOutputFile = "Output file";
const char *SysInfoConduitFactory::fTemplateFile = "Template file";
const char *SysInfoConduitFactory::fOutputType = "Output format";
const char *SysInfoConduitFactory::fHardwareInfo = "Hardware Info";
const char *SysInfoConduitFactory::fUserInfo = "User Info";
const char *SysInfoConduitFactory::fMemoryInfo = "Memory Info";
const char *SysInfoConduitFactory::fStorageInfo = "Storage Info";
const char *SysInfoConduitFactory::fDBList = "Database List";
const char *SysInfoConduitFactory::fRecordNumber = "Record Numbers";
const char *SysInfoConduitFactory::fSyncInfo = "Sync Info";
const char *SysInfoConduitFactory::fKDEVersion = "KDE Version";
const char *SysInfoConduitFactory::fPalmOSVersion = "PalmOS Version";
const char *SysInfoConduitFactory::fDebugInfo = "Debug Information";


SysInfoConduitFactory::SysInfoConduitFactory(QObject *p, const char *n) :
	KLibFactory(p,n)
{
	FUNCTIONSETUP;

	fInstance = new KInstance("SysInfoConduit");
	fAbout = new KAboutData("SysInfoConduit",
		I18N_NOOP("KPilot System Information conduit"),
		KPILOT_VERSION,
		I18N_NOOP("Retrieves System, Hardware, and User Info from the Handheld and stores them to a file."),
		KAboutData::License_GPL,
		"(C) 2003, Reinhold Kainhofer");
	fAbout->addAuthor("Reinhold Kainhofer",
		I18N_NOOP("Primary Author"), "reinhold@kainhofer.com", "http://reinhold.kainhofer.com/");
}

SysInfoConduitFactory::~SysInfoConduitFactory()
{
	FUNCTIONSETUP;

	KPILOT_DELETE(fInstance);
	KPILOT_DELETE(fAbout);
}

/* virtual */ QObject *SysInfoConduitFactory::createObject( QObject *p,
	const char *n,
	const char *c,
	const QStringList &a)
{
	FUNCTIONSETUP;

#ifdef DEBUG
	DEBUGCONDUIT << fname
		<< ": Creating object of class "
		<< c
		<< endl;
#endif

	if (qstrcmp(c,"ConduitConfigBase")==0)
	{
		QWidget *w = dynamic_cast<QWidget *>(p);
		if (w)
		{
			return new SysInfoWidgetConfig(w,"ConduitConfigBase");
		}
		else
		{
			return 0L;
		}
	}
	else
	if (qstrcmp(c,"ConduitConfig")==0)
	{
		QWidget *w = dynamic_cast<QWidget *>(p);

		if (w)
		{
			return new SysInfoWidgetSetup(w,n,a);
		}
		else
		{
			kdError() << k_funcinfo
				<< ": Couldn't cast parent to widget."
				<< endl;
			return 0L;
		}
	}

	if (qstrcmp(c,"SyncAction")==0)
	{
		KPilotDeviceLink *d = dynamic_cast<KPilotDeviceLink *>(p);

		if (d)
		{
			return new SysInfoConduit(d,n,a);
		}
		else
		{
			kdError() << k_funcinfo
				<< ": Couldn't cast parent to KPilotDeviceLink"
				<< endl;
			return 0L;
		}
	}

	return 0L;
}

